/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.util;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.time.DurationParser;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.time.TemporalAmountParser;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.NotNull;

public final class DurationUtil {
    private static final TemporalAmountParser<Duration> DATE_TIME_PARSER = new DurationParser().withUnit("s", ChronoUnit.SECONDS).withUnit("m", ChronoUnit.MINUTES).withUnit("h", ChronoUnit.HOURS).withUnit("d", ChronoUnit.DAYS).withUnit("w", ChronoUnit.WEEKS).withUnit("mo", ChronoUnit.MONTHS).withUnit("y", ChronoUnit.YEARS);

    private DurationUtil() {
        throw new UnsupportedOperationException("This is utility class.");
    }

    @NotNull
    public static String format(@NotNull Duration duration) {
        if (duration.isZero() || duration.isNegative()) {
            return "<1s";
        }
        return DATE_TIME_PARSER.format(duration);
    }

    public static long toTicks(@NotNull Duration duration) {
        if (duration.isZero() || duration.isNegative()) {
            return 0L;
        }
        return duration.toMillis() / 50L;
    }

    @NotNull
    public static Duration fromTicks(long ticks) {
        if (ticks <= 0L) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(ticks * 50L);
    }

    @NotNull
    public static TemporalAmountParser<Duration> parser() {
        return DATE_TIME_PARSER;
    }
}

