/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtil {
    private CollectionUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <T> Optional<T> select(@NotNull Collection<T> collection, int position) {
        return CollectionUtil.getByIndex(collection, position);
    }

    @NotNull
    public static <T> Optional<T> getRandom(@NotNull Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return Optional.empty();
        }
        int index = ThreadLocalRandom.current().nextInt(size);
        return CollectionUtil.getByIndex(collection, index);
    }

    @NotNull
    private static <T> Optional<T> getByIndex(@NotNull Collection<T> collection, int index) {
        if (index < 0 || index >= collection.size()) {
            return Optional.empty();
        }
        if (collection instanceof List) {
            return Optional.ofNullable(((List)collection).get(index));
        }
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return Optional.ofNullable(iterator.next());
    }
}

