/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.commons;

import com.github.imdmk.automessage.lib.eu.okaeri.configs.schema.GenericsPair;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.SerdesContext;
import java.util.Locale;
import lombok.NonNull;

public class LocaleTransformer
extends BidirectionalTransformer<String, Locale> {
    @Override
    public GenericsPair<String, Locale> getPair() {
        return this.genericsPair(String.class, Locale.class);
    }

    @Override
    public Locale leftToRight(@NonNull String data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        return Locale.forLanguageTag(this.normalize(data));
    }

    @Override
    public String rightToLeft(@NonNull Locale data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        return this.normalize(data.toString());
    }

    private String normalize(String localeTag) {
        return localeTag.replace("_", "-");
    }
}

