/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.flow.Flow;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scope.Scope;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scope.Scopeable;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.Validator;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.ValidatorScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidatorService<SENDER> {
    private final Map<Scope, Set<Validator<SENDER>>> commandValidators = new HashMap<Scope, Set<Validator<SENDER>>>();
    private final Map<Class<?>, Validator<SENDER>> validatorsByClass = new HashMap();
    private final List<Validator<SENDER>> commandGlobalValidators = new ArrayList<Validator<SENDER>>();

    public void registerValidatorGlobal(Validator<SENDER> validator) {
        this.commandGlobalValidators.add(validator);
    }

    public void registerValidator(Scope scope, Validator<SENDER> validator) {
        if (Scope.GLOBAL_SCOPE.equals(scope)) {
            this.commandGlobalValidators.add(validator);
            return;
        }
        if (scope instanceof ValidatorScope) {
            ValidatorScope validatorScope = (ValidatorScope)scope;
            this.validatorsByClass.put(validatorScope.getType(), validator);
            return;
        }
        this.commandValidators.computeIfAbsent(scope, key -> new HashSet()).add(validator);
    }

    public Flow validate(Invocation<SENDER> invocation, Scopeable scopeable) {
        Flow lastStopped = null;
        for (Validator<SENDER> validator : this.commandGlobalValidators) {
            Flow flow = validator.validate(invocation, scopeable);
            switch (flow.status()) {
                case CONTINUE: {
                    break;
                }
                case TERMINATE: {
                    return flow;
                }
                case STOP_CURRENT: {
                    lastStopped = flow;
                }
            }
        }
        for (List list : scopeable.metaCollector().iterable(Meta.VALIDATORS)) {
            for (Class validatorType : list) {
                Validator<SENDER> validator = this.validatorsByClass.get(validatorType);
                if (validator == null) {
                    throw new IllegalStateException("Validator " + validatorType + " not found");
                }
                Flow flow = validator.validate(invocation, scopeable);
                switch (flow.status()) {
                    case CONTINUE: {
                        break;
                    }
                    case TERMINATE: {
                        return flow;
                    }
                    case STOP_CURRENT: {
                        lastStopped = flow;
                    }
                }
            }
        }
        for (Map.Entry entry : this.commandValidators.entrySet()) {
            if (!((Scope)entry.getKey()).isApplicable(scopeable)) continue;
            for (Validator validator : (Set)entry.getValue()) {
                Flow flow = validator.validate(invocation, scopeable);
                switch (flow.status()) {
                    case CONTINUE: {
                        break;
                    }
                    case TERMINATE: {
                        return flow;
                    }
                    case STOP_CURRENT: {
                        lastStopped = flow;
                    }
                }
            }
        }
        if (lastStopped != null) {
            return lastStopped;
        }
        return Flow.continueFlow();
    }
}

