/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared;

import java.util.Collection;
import org.jetbrains.annotations.Contract;

public final class Preconditions {
    private Preconditions() {
    }

    @Contract(value="false, _, _ -> fail")
    public static void checkArgument(boolean value, String message, Object ... args) {
        if (!value) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(Object value, String name) {
        if (value == null) {
            throw new NullPointerException(name + " cannot be null");
        }
    }

    @Contract(value="_, _ -> fail")
    public static void isNull(Object value, String name) {
        if (value != null) {
            throw new IllegalArgumentException(name + " must be null");
        }
    }

    public static void notEmpty(Collection<?> value, String name) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void notEmpty(Object[] elements, String name) {
        if (elements.length == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void notContains(Collection<?> collection, Object element, String name, String elementName) {
        if (collection.contains(element)) {
            throw new IllegalArgumentException("Collection " + name + " already contains " + elementName);
        }
    }

    public static void notContains(Iterable<?> iterable, Object element, String name, String elementName) {
        for (Object obj : iterable) {
            if (!obj.equals(element)) continue;
            throw new IllegalArgumentException("Collection " + name + " already contains " + elementName);
        }
    }
}

