/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintAnnotation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintIndent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintModifier;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintParameter;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintPicker;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.List;

public final class PrettyPrintConstructor {
    private static final String CONSTRUCTOR_PATTERN = "{annotations}{modifiers}{generic}{name}({parameters}) {\n{indentedContent}\n}";

    public static String formatConstructor(Constructor<?> method, PrettyPrintPicker picker, String content) {
        return PrettyPrintConstructor.formatConstructor(method, -1, picker, content);
    }

    public static String formatConstructor(Constructor<?> method, Parameter parameter, String content) {
        return PrettyPrintConstructor.formatConstructor(method, PrettyPrintParameter.getParameterIndex(method, parameter), PrettyPrintPicker.PARAMETER, content);
    }

    private static String formatConstructor(Constructor<?> method, int parameter, PrettyPrintPicker picker, String content) {
        String annotations = PrettyPrintAnnotation.formatAnnotations(method.getAnnotations(), "\n", "\n");
        String modifiers = PrettyPrintModifier.formatModifiers(method.getModifiers());
        String generic = PrettyPrintType.formatGeneric(method.getTypeParameters()) + " ";
        String name = method.getName();
        List<String> formattedParameters = PrettyPrintParameter.formatParameters(method.getParameters());
        String parameters = PrettyPrintParameter.formatParameters(formattedParameters);
        int additional = 0;
        if (picker == PrettyPrintPicker.EXECUTABLE) {
            additional = modifiers.length() + generic.length();
        }
        if (picker == PrettyPrintPicker.PARAMETER && parameter != -1) {
            String pickedParameters = PrettyPrintParameter.formatParameters(formattedParameters.subList(0, parameter));
            additional = modifiers.length() + generic.length() + name.length() + pickedParameters.length() + " ".length();
        }
        String indentedContent = PrettyPrintIndent.indentedContent(content, additional);
        return CONSTRUCTOR_PATTERN.replace("{annotations}", annotations).replace("{modifiers}", modifiers).replace("{generic}", generic).replace("{name}", name).replace("{parameters}", parameters).replace("{indentedContent}", indentedContent);
    }
}

