/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaHolder;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MissingPermissions {
    private final List<String> checkedPermissions;
    private final List<String> missingPermissions;

    private MissingPermissions(List<String> checkedPermissions, List<String> missingPermissions) {
        this.checkedPermissions = checkedPermissions;
        this.missingPermissions = missingPermissions;
    }

    public List<String> getChecked() {
        return Collections.unmodifiableList(this.checkedPermissions);
    }

    public List<String> getPermissions() {
        return Collections.unmodifiableList(this.missingPermissions);
    }

    public String asJoinedText() {
        return this.asJoinedText(", ");
    }

    public String asJoinedText(String separator) {
        return String.join((CharSequence)separator, this.missingPermissions);
    }

    public boolean isMissing() {
        return !this.missingPermissions.isEmpty();
    }

    public boolean isPermitted() {
        return this.missingPermissions.isEmpty();
    }

    public static MissingPermissions check(PlatformSender platformSender, MetaHolder metaHolder) {
        ArrayList<String> collected = new ArrayList<String>();
        ArrayList<String> missingPermissions = new ArrayList<String>();
        MetaHolder current = metaHolder;
        while (current != null) {
            if (!current.meta().has(Meta.PERMISSIONS)) {
                current = current.parentMeta();
                continue;
            }
            List<String> permissions = current.meta().get(Meta.PERMISSIONS);
            for (String permission : permissions) {
                collected.add(permission);
                if (platformSender.hasPermission(permission)) continue;
                missingPermissions.add(permission);
            }
            current = current.parentMeta();
        }
        return new MissingPermissions(collected, missingPermissions);
    }

    public static MissingPermissions missing(String ... permissions) {
        return new MissingPermissions(Arrays.asList(permissions), Arrays.asList(permissions));
    }
}

