/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.ArgumentKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.CooldownContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaEmptyImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaListEditor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaType;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.PriorityLevel;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.SchedulerPoll;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.strict.StrictMode;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.Validator;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.requirement.RequirementValidator;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Meta {
    public static final MetaKey<List<String>> DESCRIPTION = MetaKey.of("description", MetaType.list(), Collections.emptyList());
    public static final MetaKey<List<String>> PERMISSIONS = MetaKey.of("permissions", MetaType.list(), Collections.emptyList());
    public static final MetaKey<PriorityLevel> PRIORITY = MetaKey.of("priority", PriorityLevel.class, PriorityLevel.NORMAL);
    public static final MetaKey<Boolean> NATIVE_PERMISSIONS = MetaKey.of("native-permissions", Boolean.class, Boolean.valueOf(false));
    public static final MetaKey<SchedulerPoll> POLL_TYPE = MetaKey.of("poll-type", SchedulerPoll.class, SchedulerPoll.MAIN);
    @Deprecated
    public static final MetaKey<ArgumentKey> ARGUMENT_KEY = MetaKey.of("argument-key", ArgumentKey.class, ArgumentKey.of());
    public static final MetaKey<List<Class>> COMMAND_ORIGIN_TYPE = MetaKey.of("command-origin-class", MetaType.list(), Collections.emptyList());
    public static final MetaKey<List<Class<? extends Validator<?>>>> VALIDATORS = MetaKey.of("validators", MetaType.list(), Collections.emptyList());
    public static final MetaKey<List<RequirementValidator<?, ?>>> REQUIREMENT_VALIDATORS = MetaKey.of("requirement-validators", MetaType.list(), Collections.emptyList());
    public static final MetaKey<CooldownContext> COOLDOWN = MetaKey.of("cooldown", CooldownContext.class);
    public static final MetaKey<StrictMode> STRICT_MODE = MetaKey.of("strict-mode", StrictMode.class, StrictMode.DEFAULT);
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.12.0")
    public static final MetaKey<Parameter> REQUIREMENT_PARAMETER = MetaKey.of("requirement-parameter", Parameter.class);
    public static final Meta EMPTY_META = new MetaEmptyImpl();

    @NotNull
    public <T> T get(MetaKey<T> var1);

    @Contract(value="_, !null -> !null; _, null -> _")
    public <T> T get(MetaKey<T> var1, T var2);

    public <T> Meta put(MetaKey<T> var1, T var2);

    @ApiStatus.Experimental
    public <T> Meta edit(MetaKey<T> var1, UnaryOperator<T> var2);

    public <T> Meta remove(MetaKey<T> var1);

    public Meta clear();

    public boolean has(MetaKey<?> var1);

    default public <E> MetaListEditor<E> listEditor(MetaKey<List<E>> key) {
        return new MetaListEditor<E>(this.get(key), this, key);
    }

    default public <E> Meta list(MetaKey<List<E>> key, UnaryOperator<MetaListEditor<E>> operator) {
        MetaListEditor<E> editor = this.listEditor(key);
        return ((MetaListEditor)operator.apply(editor)).apply();
    }

    @Deprecated
    default public Meta apply(Meta meta) {
        return this.putAll(meta);
    }

    public Meta putAll(Meta var1);

    public Meta copy();

    public Collection<MetaKey<?>> getKeys();

    public static Meta create() {
        return new MetaImpl();
    }
}

