/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.InvokedMessage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.Message;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.MessageKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MessageRegistry<SENDER> {
    private final Map<MessageKey<?>, Message<?, ?>> messages = new HashMap();
    private final Map<MessageKey<?>, InvokedMessage<SENDER, ?, ?>> invokedMessages = new HashMap();

    public <T, CONTEXT> void register(MessageKey<CONTEXT> key, Message<T, CONTEXT> message) {
        this.messages.put(key, message);
    }

    public <T, CONTEXT> void register(MessageKey<CONTEXT> key, InvokedMessage<SENDER, T, CONTEXT> message) {
        this.invokedMessages.put(key, message);
    }

    public Optional<Object> getInvoked(MessageKey<Void> key, Invocation<SENDER> invocation) {
        return this.getInvoked(key, invocation, null);
    }

    public <CONTEXT> Optional<Object> getInvoked(MessageKey<CONTEXT> key, Invocation<SENDER> invocation, CONTEXT context) {
        InvokedMessage<SENDER, ?, ?> invokedMessage = this.invokedMessages.get(key);
        if (invokedMessage != null) {
            return Optional.of(invokedMessage.get(invocation, context));
        }
        return this.get(key, context);
    }

    @Deprecated
    public <CONTEXT> Optional<Object> get(MessageKey<CONTEXT> key, CONTEXT context) {
        Message<?, ?> message = this.messages.get(key);
        if (message == null) {
            return Optional.of(key.getDefaultMessage(context));
        }
        return Optional.of(message.get(context));
    }

    @Deprecated
    public Optional<Object> get(MessageKey<Void> key) {
        return this.get(key, null);
    }
}

