/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.Preconditions;
import java.util.function.Function;

public class MessageKey<CONTEXT> {
    private final String name;
    private final Function<CONTEXT, Object> defaultMessage;

    private MessageKey(String name, Function<CONTEXT, Object> defaultMessage) {
        this.name = name;
        this.defaultMessage = defaultMessage;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultMessage(CONTEXT context) {
        return this.defaultMessage.apply(context);
    }

    public static <CONTEXT> MessageKey<CONTEXT> of(String name, Object defaultMessage) {
        return MessageKey.of(name, (CONTEXT context) -> defaultMessage);
    }

    public static <CONTEXT> MessageKey<CONTEXT> of(String name, Function<CONTEXT, Object> defaultMessage) {
        Preconditions.notNull(name, "name");
        Preconditions.notNull(defaultMessage, "defaultMessage");
        return new MessageKey<CONTEXT>(name, defaultMessage);
    }
}

