/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InvocationContext {
    private final Map<Class<?>, Object> context = new HashMap();

    private InvocationContext() {
    }

    public <T> Optional<T> get(Class<T> type) {
        return MapUtil.findByInstanceOf(type, this.context);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final InvocationContext context = new InvocationContext();

        public <T> Builder put(Class<T> type, T value) {
            this.context.context.put(type, value);
            return this;
        }

        public Builder putUnsafe(Class<?> type, Object value) {
            this.context.context.put(type, value);
            return this;
        }

        public Builder put(Object value) {
            if (value == null) {
                return this;
            }
            return this.putUnsafe(value.getClass(), value);
        }

        public InvocationContext build() {
            return this.context;
        }
    }
}

