/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInputView;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

class ViewBasedRawInputImpl
implements RawInput {
    private final RawInputView rawInputView;

    public ViewBasedRawInputImpl(RawInputView rawInputView) {
        this.rawInputView = rawInputView;
    }

    @Override
    public boolean hasNext() {
        return !this.rawInputView.content().isEmpty();
    }

    @Override
    public String next() {
        int index = this.rawInputView.indexOf(" ");
        if (index == -1) {
            return this.rawInputView.claim();
        }
        return this.rawInputView.claim(0, index);
    }

    @Override
    public List<String> next(int count) {
        ArrayList<String> list = new ArrayList<String>();
        String content = this.rawInputView.content();
        int spaceCount = 0;
        int indexToClaim = 0;
        for (String element : StringUtil.splitBySpace(content)) {
            if (spaceCount >= count) break;
            list.add(element);
            ++spaceCount;
            indexToClaim += element.length() + " ".length();
        }
        if (spaceCount < count) {
            throw new IllegalArgumentException("Cannot consume next " + count + " arguments, only " + spaceCount + " left");
        }
        this.rawInputView.claim(0, indexToClaim);
        return list;
    }

    @Override
    public List<String> nextAll() {
        return StringUtil.splitBySpace(this.rawInputView.claim());
    }

    @Override
    public String seeNext() {
        String content = this.rawInputView.content();
        int index = this.rawInputView.indexOf(" ");
        if (index == -1) {
            return content;
        }
        return content.substring(0, index);
    }

    @Override
    public List<String> seeNext(int count) {
        ArrayList<String> list = new ArrayList<String>();
        String content = this.rawInputView.content();
        int spaceCount = 0;
        for (String element : StringUtil.splitBySpace(content)) {
            if (spaceCount >= count) break;
            list.add(element);
            ++spaceCount;
        }
        if (spaceCount < count) {
            throw new IllegalArgumentException("Cannot see next " + count + " arguments, only " + spaceCount + " left");
        }
        return list;
    }

    @Override
    public List<String> seeAll() {
        return StringUtil.splitBySpace(this.rawInputView.content());
    }

    @Override
    public int size() {
        return this.rawInputView.countOf(' ') - 1;
    }

    @Override
    public int consumedCount() {
        String sourceContent = this.rawInputView.sourceContent();
        String content = this.rawInputView.content();
        int count = StringUtil.countOf(sourceContent, ' ');
        int countNow = StringUtil.countOf(content, ' ');
        if (!sourceContent.isEmpty()) {
            ++count;
        }
        if (!content.isEmpty()) {
            ++countNow;
        }
        return count - countNow;
    }
}

