/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommandsException;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandleService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandlerChain;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandlerChainImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.MapUtil;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.ObjectsUtil;
import java.util.HashMap;
import java.util.Map;

public class ResultHandleServiceImpl<SENDER>
implements ResultHandleService<SENDER> {
    private final Map<Class<?>, ResultHandler<SENDER, ?>> handlers = new HashMap();

    @Override
    public <T> void registerHandler(Class<T> resultType, ResultHandler<SENDER, ? extends T> handler) {
        this.handlers.put(resultType, handler);
    }

    @Override
    public <T> void resolve(Invocation<SENDER> invocation, T result) {
        ResultHandlerChainImpl chain = new ResultHandlerChainImpl(this);
        this.resolve(invocation, result, result.getClass(), chain);
    }

    @Override
    public <T> void resolve(Invocation<SENDER> invocation, T result, Class<? super T> typedAs, ResultHandlerChain<SENDER> chain) {
        ResultHandler<SENDER, T> handler = this.getHandler(typedAs);
        if (handler == null) {
            throw new LiteCommandsException("Cannot find handler for result type " + typedAs.getName());
        }
        if (typedAs.isArray() && typedAs.getComponentType().isPrimitive()) {
            result = ObjectsUtil.getGenericCopyOfPrimitiveArray(result);
        }
        handler.handle(invocation, result, chain);
    }

    private <T> ResultHandler<SENDER, T> getHandler(Class<T> resultType) {
        ResultHandler<SENDER, ?> handler = this.handlers.get(resultType);
        if (handler != null) {
            return handler;
        }
        return MapUtil.findBySuperTypeOf(resultType, this.handlers).orElse(null);
    }
}

