/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecuteResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.Preconditions;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CommandExecutorMatchResult {
    @Nullable
    private final Supplier<CommandExecuteResult> preparedExecutor;
    @Nullable
    private final FailedReason failedReason;

    private CommandExecutorMatchResult(@Nullable Supplier<CommandExecuteResult> preparedExecutor, @Nullable FailedReason failedReason) {
        this.preparedExecutor = preparedExecutor;
        this.failedReason = failedReason;
    }

    public CommandExecuteResult executeCommand() {
        Preconditions.checkArgument(this.preparedExecutor != null, "Cannot execute command when it failed", new Object[0]);
        return this.preparedExecutor.get();
    }

    public FailedReason getFailedReason() {
        Preconditions.checkArgument(this.isFailed(), "Cannot get failed reason when command was successful", new Object[0]);
        return this.failedReason;
    }

    public boolean isFailed() {
        return this.failedReason != null;
    }

    public boolean isSuccessful() {
        return this.preparedExecutor != null;
    }

    public static CommandExecutorMatchResult success(Supplier<CommandExecuteResult> preparedExecutor) {
        return new CommandExecutorMatchResult(preparedExecutor, null);
    }

    public static CommandExecutorMatchResult failed(FailedReason failedReason) {
        return new CommandExecutorMatchResult(null, failedReason);
    }

    public static CommandExecutorMatchResult failed(Object failedReason) {
        return new CommandExecutorMatchResult(null, FailedReason.of(failedReason));
    }
}

