/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommandsException;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRoute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecuteResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutorMatchResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.LastExceptionHandler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CandidateExecutorFoundEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CandidateExecutorMatchEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandPostExecutionEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandPreExecutionEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.flow.ExecuteFlow;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.event.EventPublisher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.flow.Flow;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandleService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsageException;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementMatchService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.SchedulerPoll;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.ValidatorService;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jetbrains.annotations.Nullable;

public class CommandExecuteService<SENDER> {
    private final ValidatorService<SENDER> validatorService;
    private final ResultHandleService<SENDER> resultResolver;
    private final Scheduler scheduler;
    private final RequirementMatchService<SENDER> requirementMatchService;
    private final EventPublisher publisher;

    public CommandExecuteService(ValidatorService<SENDER> validatorService, ResultHandleService<SENDER> resultResolver, Scheduler scheduler, RequirementMatchService<SENDER> requirementMatchService, EventPublisher publisher) {
        this.validatorService = validatorService;
        this.resultResolver = resultResolver;
        this.scheduler = scheduler;
        this.requirementMatchService = requirementMatchService;
        this.publisher = publisher;
    }

    public CompletableFuture<CommandExecuteResult> execute(Invocation<SENDER> invocation, ParseableInputMatcher<?> matcher, CommandRoute<SENDER> commandRoute) {
        return ((CompletableFuture)((CompletableFuture)this.execute0(invocation, matcher, commandRoute).thenApply(result -> this.publishAndApplyEvent(invocation, commandRoute, (CommandExecuteResult)result))).thenCompose(executeResult -> this.scheduler.supply(SchedulerPoll.MAIN, () -> this.handleResult(invocation, (CommandExecuteResult)executeResult)))).exceptionally(new LastExceptionHandler<SENDER>(this.resultResolver, invocation));
    }

    private CommandExecuteResult publishAndApplyEvent(Invocation<SENDER> invocation, CommandRoute<SENDER> route, CommandExecuteResult result) {
        if (this.publisher.hasSubscribers(CommandPostExecutionEvent.class)) {
            CommandExecutor<?> executor = result.getExecutor();
            result = this.publisher.publish(new CommandPostExecutionEvent<SENDER>(invocation, route, executor, result)).getResult();
        }
        return result;
    }

    private CommandExecuteResult handleResult(Invocation<SENDER> invocation, CommandExecuteResult executeResult) {
        Object error;
        Object result;
        Throwable throwable = executeResult.getThrowable();
        if (throwable != null) {
            this.resultResolver.resolve(invocation, throwable);
        }
        if ((result = executeResult.getResult()) != null) {
            this.resultResolver.resolve(invocation, result);
        }
        if ((error = executeResult.getError()) != null) {
            this.resultResolver.resolve(invocation, error);
        }
        return executeResult;
    }

    private <MATCHER extends ParseableInputMatcher<MATCHER>> CompletableFuture<CommandExecuteResult> execute0(Invocation<SENDER> invocation, ParseableInputMatcher<MATCHER> matcher, CommandRoute<SENDER> commandRoute) {
        return this.execute(commandRoute.getExecutors().iterator(), invocation, matcher, commandRoute, null);
    }

    private <MATCHER extends ParseableInputMatcher<MATCHER>> CompletableFuture<CommandExecuteResult> execute(Iterator<CommandExecutor<SENDER>> executors, Invocation<SENDER> invocation, ParseableInputMatcher<MATCHER> matcher, CommandRoute<SENDER> commandRoute, @Nullable FailedReason last) {
        if (!executors.hasNext()) {
            CommandExecutor<SENDER> executor;
            Flow validate = this.validatorService.validate(invocation, commandRoute);
            if (validate.isTerminate() || validate.isStopCurrent()) {
                return CompletableFuture.completedFuture(CommandExecuteResult.failed(validate.getReason()));
            }
            CommandExecutor<SENDER> commandExecutor = executor = commandRoute.getExecutors().isEmpty() ? null : commandRoute.getExecutors().last();
            if (last != null && last.hasResult()) {
                return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, last));
            }
            return CompletableFuture.completedFuture(CommandExecuteResult.failed((Object)InvalidUsage.Cause.UNKNOWN_COMMAND));
        }
        CommandExecutor<SENDER> executor = executors.next();
        if (this.publisher.hasSubscribers(CandidateExecutorFoundEvent.class)) {
            CandidateExecutorFoundEvent<SENDER> foundEvent = this.publisher.publish(new CandidateExecutorFoundEvent<SENDER>(invocation, executor));
            if (foundEvent.getFlow() == ExecuteFlow.STOP) {
                return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, foundEvent.getFlowResult()));
            }
            if (foundEvent.getFlow() == ExecuteFlow.SKIP) {
                return this.execute(executors, invocation, matcher, commandRoute, FailedReason.max(foundEvent.getFlowResult(), last));
            }
        }
        return ((CompletableFuture)this.requirementMatchService.match(executor, invocation, matcher.copy()).thenCompose(match -> {
            if (this.publisher.hasSubscribers(CandidateExecutorMatchEvent.class)) {
                CandidateExecutorMatchEvent matchEvent = this.publisher.publish(new CandidateExecutorMatchEvent(invocation, executor, (CommandExecutorMatchResult)match));
                if (matchEvent.getFlow() == ExecuteFlow.STOP) {
                    return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, matchEvent.getFlowResult()));
                }
                if (matchEvent.getFlow() == ExecuteFlow.SKIP) {
                    return this.execute(executors, invocation, matcher, commandRoute, FailedReason.max(matchEvent.getFlowResult(), last));
                }
            }
            if (match.isFailed()) {
                FailedReason current = match.getFailedReason();
                if (current.hasResult()) {
                    return this.execute(executors, invocation, matcher, commandRoute, FailedReason.max(current, last));
                }
                return this.execute(executors, invocation, matcher, commandRoute, last);
            }
            if (this.publisher.hasSubscribers(CommandPreExecutionEvent.class)) {
                CommandPreExecutionEvent executionEvent = this.publisher.publish(new CommandPreExecutionEvent(invocation, executor));
                if (executionEvent.getFlow() == ExecuteFlow.STOP) {
                    return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, executionEvent.getFlowResult()));
                }
                if (executionEvent.getFlow() == ExecuteFlow.SKIP) {
                    return this.execute(executors, invocation, matcher, commandRoute, FailedReason.max(executionEvent.getFlowResult(), last));
                }
            }
            SchedulerPoll type = executor.metaCollector().findFirst(Meta.POLL_TYPE);
            return this.scheduler.supply(type, () -> this.execute((CommandExecutorMatchResult)match, executor));
        })).exceptionally(throwable -> this.toThrown(executor, (Throwable)throwable));
    }

    private CommandExecuteResult toThrown(CommandExecutor<SENDER> executor, Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return CommandExecuteResult.thrown(executor, throwable.getCause());
        }
        return CommandExecuteResult.thrown(executor, throwable);
    }

    private CommandExecuteResult execute(CommandExecutorMatchResult match, CommandExecutor<SENDER> executor) {
        try {
            return match.executeCommand();
        }
        catch (LiteCommandsException exception) {
            if (exception.getCause() instanceof InvalidUsageException) {
                return CommandExecuteResult.failed(executor, ((InvalidUsageException)exception.getCause()).getErrorResult());
            }
            return CommandExecuteResult.thrown(executor, exception);
        }
        catch (Throwable error) {
            return CommandExecuteResult.thrown(executor, error);
        }
    }
}

