/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.builder;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandExecutorProvider;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRoute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.builder.CommandBuilderImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.builder.CommandBuilderRootImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaHolder;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scope.Scopeable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandBuilder<SENDER>
extends Scopeable,
MetaHolder {
    @NotNull
    public CommandBuilder<SENDER> name(String var1);

    public String name();

    @NotNull
    public CommandBuilder<SENDER> aliases(List<String> var1);

    @NotNull
    public CommandBuilder<SENDER> aliases(String ... var1);

    public boolean isNameOrAlias(String var1);

    public boolean hasSimilarNames(CommandBuilder<SENDER> var1);

    public List<String> aliases();

    public List<String> names();

    @NotNull
    public CommandBuilder<SENDER> enable();

    @NotNull
    public CommandBuilder<SENDER> enabled(boolean var1);

    @NotNull
    public CommandBuilder<SENDER> disable();

    @NotNull
    public CommandBuilder<SENDER> editChild(String var1, UnaryOperator<CommandBuilder<SENDER>> var2);

    @NotNull
    public CommandBuilder<SENDER> appendChild(String var1, UnaryOperator<CommandBuilder<SENDER>> var2);

    @NotNull
    public CommandBuilder<SENDER> appendChild(CommandBuilder<SENDER> var1);

    public Collection<CommandBuilder<SENDER>> children();

    public Optional<CommandBuilder<SENDER>> getChild(String var1);

    public CommandBuilder<SENDER> appendExecutor(CommandExecutorProvider<SENDER> var1);

    public Collection<CommandExecutorProvider<SENDER>> executors();

    public CommandBuilder<SENDER> applyMeta(UnaryOperator<Meta> var1);

    @Override
    public Meta meta();

    @ApiStatus.Internal
    public CommandBuilder<SENDER> routeName(String var1);

    @ApiStatus.Internal
    public CommandBuilder<SENDER> routeAliases(List<String> var1);

    @ApiStatus.Internal
    public CommandBuilder<SENDER> applyOnRoute(UnaryOperator<CommandBuilder<SENDER>> var1);

    @ApiStatus.Internal
    public CommandBuilder<SENDER> getRealRoute();

    @ApiStatus.Experimental
    public CommandBuilder<SENDER> shortcuts(List<String> var1);

    @ApiStatus.Internal
    public CommandBuilder<SENDER> shortcuts(CommandExecutorProvider<SENDER> var1, List<String> var2);

    @ApiStatus.Internal
    public void meagre(CommandBuilder<SENDER> var1);

    @ApiStatus.Internal
    public boolean isEnabled();

    @ApiStatus.Internal
    public boolean buildable();

    @ApiStatus.Internal
    @Nullable
    public CommandBuilder<SENDER> parent();

    default public boolean isRoot() {
        return false;
    }

    @ApiStatus.Internal
    public Collection<CommandRoute<SENDER>> build(CommandRoute<SENDER> var1);

    public static <SENDER> CommandBuilder<SENDER> create() {
        return new CommandBuilderImpl();
    }

    public static <SENDER> CommandBuilder<SENDER> createRoot() {
        return new CommandBuilderRootImpl();
    }
}

