/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.argument;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerArgument
extends ArgumentResolver<CommandSender, Player> {
    private final Server server;
    private final MessageRegistry<CommandSender> messageRegistry;

    public PlayerArgument(Server server, MessageRegistry<CommandSender> messageRegistry) {
        this.server = server;
        this.messageRegistry = messageRegistry;
    }

    @Override
    protected ParseResult<Player> parse(Invocation<CommandSender> invocation, Argument<Player> context, String argument) {
        Player player = this.server.getPlayer(argument);
        if (player != null) {
            return ParseResult.success(player);
        }
        return ParseResult.failure(this.messageRegistry.getInvoked(LiteBukkitMessages.PLAYER_NOT_FOUND, invocation, argument));
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Player> argument, SuggestionContext context) {
        return (SuggestionResult)this.server.getOnlinePlayers().stream().collect(SuggestionResult.collector(player -> player.getName(), player -> player.getUniqueId().toString()));
    }
}

