/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.argument;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.time.Instant;
import java.util.TreeSet;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class OfflinePlayerArgument
extends ArgumentResolver<CommandSender, OfflinePlayer> {
    private static final int SUGGESTION_LIMIT = 256;
    private final Server server;
    private final Plugin plugin;
    private final boolean enableThreadCheck;
    private final TreeSet<String> nicknames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private Instant nextWarningDate = Instant.EPOCH;

    public OfflinePlayerArgument(Server server, Plugin plugin, boolean enableThreadCheck) {
        this.server = server;
        this.plugin = plugin;
        this.enableThreadCheck = enableThreadCheck;
        for (OfflinePlayer offlinePlayer : server.getOfflinePlayers()) {
            String name = offlinePlayer.getName();
            if (name == null) continue;
            this.nicknames.add(name);
        }
        server.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerJoin(PlayerJoinEvent event) {
                OfflinePlayerArgument.this.nicknames.add(event.getPlayer().getName());
            }
        }, plugin);
    }

    @Override
    protected ParseResult<OfflinePlayer> parse(Invocation<CommandSender> invocation, Argument<OfflinePlayer> context, String argument) {
        if (this.enableThreadCheck && this.server.isPrimaryThread() && Instant.now().isAfter(this.nextWarningDate)) {
            this.plugin.getLogger().warning("LiteCommands | OfflinePlayer argument resolved synchronously! This might cause server freeze! Add @Async to '" + context.getName() + "' argument. (command /" + invocation.name() + ")");
            this.nextWarningDate = Instant.now().plusSeconds(60L);
        }
        return ParseResult.success(this.server.getOfflinePlayer(argument));
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<OfflinePlayer> argument, SuggestionContext context) {
        if (this.nicknames.size() < 256) {
            return SuggestionResult.of(this.nicknames);
        }
        String input = context.getCurrent().multilevel();
        if (input.isEmpty()) {
            return this.nicknames.stream().limit(256L).collect(SuggestionResult.collector());
        }
        return this.nicknames.subSet(input, input + '\uffff').stream().limit(256L).collect(SuggestionResult.collector());
    }
}

