/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.standard;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class TemporalAccessorUtils {
    private static final int WEEK_DAYS = 7;
    private static final int HOURS_IN_DAY = 24;
    private static final int YEARS_IN_DECADE = 10;

    private TemporalAccessorUtils() {
    }

    static <T extends Temporal> List<T> allDaysOfWeek(T start) {
        return TemporalAccessorUtils.generateTemporal(start, ChronoUnit.DAYS, 7);
    }

    static <T extends Temporal> List<T> allHoursOfDay(T start) {
        return TemporalAccessorUtils.generateTemporal(start, ChronoUnit.HOURS, 24);
    }

    static <T extends Temporal> List<T> allYearsOfDecade(T start) {
        return TemporalAccessorUtils.generateTemporal(start, ChronoUnit.YEARS, 10);
    }

    private static <T extends Temporal> List<T> generateTemporal(T start, ChronoUnit unit, int countGenerate) {
        Class<?> temporalClass = start.getClass();
        return IntStream.range(0, countGenerate).boxed().map(temporalCount -> start.plus(temporalCount.intValue(), unit)).filter(temporalClass::isInstance).map(temporalClass::cast).collect(Collectors.toList());
    }
}

