/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.collector;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.collector.AbstractCollectorArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.collector.VarargsProfile;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeToken;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class TreeSetArgumentResolver<SENDER>
extends AbstractCollectorArgumentResolver<SENDER, TreeSet> {
    public TreeSetArgumentResolver(ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry) {
        super(parserRegistry, suggesterRegistry);
    }

    @Override
    public boolean canParse(Argument<TreeSet> argument, VarargsProfile varargsProfile) {
        if (!super.canParse(argument)) {
            return false;
        }
        TypeToken<Comparable> elementType = varargsProfile.getElementType();
        if (elementType.isInstanceOf(Comparable.class)) {
            return true;
        }
        throw new IllegalArgumentException(elementType.getRawType().getSimpleName() + " is not comparable! (argument: " + argument + ")");
    }

    @Override
    <E> Collector<E, ?, ? extends TreeSet<E>> getCollector(VarargsProfile varargsProfile, Invocation<SENDER> invocation) {
        return Collectors.toCollection(() -> new TreeSet());
    }
}

