/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.collector;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseCompletedResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.Parser;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.profile.ProfiledMultipleArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.collector.VarargsProfile;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.Suggester;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutorMatchResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInputView;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInputViewLegacyAdapter;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.range.Range;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeToken;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementCondition;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.Suggestion;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.FutureUtil;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCollectorArgumentResolver<SENDER, COLLECTION>
extends ProfiledMultipleArgumentResolver<SENDER, COLLECTION, VarargsProfile> {
    private static final int BASE_ARGUMENT_COUNT = 1;
    private static final int NO_INDEX = -1;
    private final ParserRegistry<SENDER> parserRegistry;
    private final SuggesterRegistry<SENDER> suggesterRegistry;

    protected AbstractCollectorArgumentResolver(ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry) {
        super(VarargsProfile.NAMESPACE);
        this.parserRegistry = parserRegistry;
        this.suggesterRegistry = suggesterRegistry;
    }

    @Override
    protected ParseResult<COLLECTION> parse(Invocation<SENDER> invocation, Argument<COLLECTION> context, RawInput rawInput, VarargsProfile collectionArgument) {
        return this.parse(this.getElementType(collectionArgument), rawInput, context, collectionArgument, invocation);
    }

    private <E> ParseResult<COLLECTION> parse(TypeToken<E> componentType, RawInput rawInput, Argument<COLLECTION> argument, VarargsProfile collectionArgument, Invocation<SENDER> invocation) {
        Collector collector = this.getCollector(collectionArgument, invocation);
        return this.parseToList(componentType, rawInput, argument, collectionArgument, invocation).map(list -> list.stream().collect(collector)).mapFailure(failedReason -> {
            Object empty = Stream.empty().collect(collector);
            return ParseResult.conditional(empty, new SuccessRequirementCondition(failedReason));
        });
    }

    @Override
    public boolean match(Invocation<SENDER> invocation, Argument<COLLECTION> context, RawInput input, VarargsProfile collectionArgument) {
        return this.match0(invocation, context, input, collectionArgument);
    }

    private <E> boolean match0(Invocation<SENDER> invocation, Argument<COLLECTION> collectionArgument, RawInput input, VarargsProfile collectionArgumentContainer) {
        if (input.hasNext() && input.seeNext().isEmpty()) {
            input.next();
            return true;
        }
        RawInputViewLegacyAdapter view = new RawInputViewLegacyAdapter(input);
        TypeToken<E> elementType = this.getElementType(collectionArgumentContainer);
        Argument argument = collectionArgument.child(elementType).withoutProfile(VarargsProfile.NAMESPACE);
        Parser parser = this.parserRegistry.getParser(argument);
        Range range = parser.getRange(argument);
        ParseCompletedResult<List<List<String>>> result = this.findRawValues(view, range, collectionArgumentContainer.getDelimiter());
        if (result.isFailed()) {
            return false;
        }
        boolean isAllMatch = result.getSuccess().stream().allMatch(rawResult -> parser.match(invocation, argument, RawInput.of(rawResult)));
        if (isAllMatch) {
            view.applyChanges();
        }
        return true;
    }

    private <E> ParseResult<List<E>> parseToList(TypeToken<E> componentType, RawInput rawInput, Argument<COLLECTION> collectionArgument, VarargsProfile collectorArgumentHolder, Invocation<SENDER> invocation) {
        Argument argument = collectionArgument.child(componentType).withoutProfile(VarargsProfile.NAMESPACE);
        Parser parser = this.parserRegistry.getParser(argument);
        if (rawInput.hasNext() && rawInput.seeNext().isEmpty()) {
            String next = rawInput.next();
            if (parser.getRange(argument).isInRange(1)) {
                return parser.parse(invocation, argument, RawInput.of(next)).map(elementResult -> Collections.singletonList(elementResult)).mapFailure(failedReason -> ParseResult.success(Collections.emptyList()));
            }
            return ParseResult.success(Collections.emptyList());
        }
        Range range = parser.getRange(argument);
        String delimiter = collectorArgumentHolder.getDelimiter();
        RawInputViewLegacyAdapter view = new RawInputViewLegacyAdapter(rawInput);
        return this.findRawValues(view, range, delimiter).flatMap(rawResults -> ParseResult.completableFuture(this.parseRawResults((List<List<String>>)rawResults, invocation, argument, parser))).whenSuccessful(list -> view.applyChanges());
    }

    private ParseCompletedResult<List<List<String>>> findRawValues(RawInputView view, Range range, String delimiter) {
        List<String> arguments;
        RawInputView elementView = this.findNextElementView(view, range, delimiter);
        ArrayList<List<String>> rawResults = new ArrayList<List<String>>();
        while (elementView != null) {
            String elementWithDelimiter = elementView.claim();
            String element = elementWithDelimiter.substring(0, elementWithDelimiter.length() - delimiter.length());
            arguments = StringUtil.splitBySpace(element);
            if (range.isBelowRange(arguments.size())) {
                return ParseResult.failure((Object)InvalidUsage.Cause.MISSING_PART_OF_ARGUMENT);
            }
            rawResults.add(arguments);
            elementView = this.findNextElementView(view, range, delimiter);
        }
        int lastIndex = this.lastIndexOfInRange(view, range);
        if (lastIndex == -1) {
            if (rawResults.isEmpty()) {
                return ParseResult.success(Collections.emptyList());
            }
            return ParseResult.failure((Object)InvalidUsage.Cause.MISSING_PART_OF_ARGUMENT);
        }
        String rest = view.claim(0, lastIndex + 1);
        arguments = StringUtil.splitBySpace(rest);
        rawResults.add(arguments);
        return ParseResult.success(rawResults);
    }

    private <E> CompletableFuture<ParseCompletedResult<List<E>>> parseRawResults(List<List<String>> rawResults, Invocation<SENDER> invocation, Argument<E> argument, Parser<SENDER, E> parser) {
        List futures = rawResults.stream().map(rawResult -> parser.parse(invocation, argument, RawInput.of(rawResult)).asFuture()).collect(Collectors.toList());
        return FutureUtil.asList(futures).thenApply(requirementResults -> {
            for (ParseCompletedResult result2 : requirementResults) {
                if (!result2.isFailed()) continue;
                return ParseResult.failure(result2.getFailedReason());
            }
            List results = requirementResults.stream().map(result -> result.getSuccess()).collect(Collectors.toList());
            return ParseResult.success(results);
        });
    }

    private int lastIndexOfInRange(RawInputView view, Range range) {
        String content = view.content();
        int index = -1;
        for (int count = 1; count <= range.getMax(); ++count) {
            int indexOf = content.indexOf(32, index + 1);
            if (indexOf == -1) {
                if (range.isBelowRange(count)) {
                    return -1;
                }
                return content.length() - 1;
            }
            index = indexOf;
        }
        return index;
    }

    abstract <E> Collector<E, ?, ? extends COLLECTION> getCollector(VarargsProfile var1, Invocation<SENDER> var2);

    @Override
    public Range getRange(Argument<COLLECTION> argument, VarargsProfile varargsProfile) {
        return Range.moreThan(0);
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<COLLECTION> argument, SuggestionContext context, VarargsProfile varargsProfile) {
        return this.suggest(this.getElementType(varargsProfile), context, argument, varargsProfile, invocation);
    }

    private <T> SuggestionResult suggest(TypeToken<T> componentType, SuggestionContext context, Argument<COLLECTION> collectionArgument, VarargsProfile varargsProfile, Invocation<SENDER> invocation) {
        Argument<T> argument = collectionArgument.child(componentType).withoutProfile(VarargsProfile.NAMESPACE);
        Parser<SENDER, T> parser = this.parserRegistry.getParser(argument);
        Suggester<SENDER, T> suggester = this.suggesterRegistry.getSuggester(componentType.getRawType(), argument.getKey());
        Suggestion current = context.getCurrent();
        Range range = parser.getRange(argument);
        String delimiter = varargsProfile.getDelimiter();
        RawInputView fullView = RawInputView.of(current.multilevel());
        return this.suggestWithDelimiter(fullView, argument, suggester, parser, range, delimiter, context, invocation);
    }

    private <T> SuggestionResult suggestWithDelimiter(RawInputView fullView, Argument<T> argument, Suggester<SENDER, T> suggester, Parser<SENDER, T> parser, Range range, String delimiter, SuggestionContext context, Invocation<SENDER> invocation) {
        Suggestion current = context.getCurrent();
        RawInputView elementView = this.findNextElementView(fullView, range, delimiter);
        if (elementView != null) {
            String elementWithDelimiter = elementView.claim();
            String element = elementWithDelimiter.substring(0, elementWithDelimiter.length() - delimiter.length());
            List<String> arguments = StringUtil.splitBySpace(element);
            if (!range.isInRange(arguments.size())) {
                return SuggestionResult.empty();
            }
            return this.suggestWithDelimiter(fullView, argument, suggester, parser, range, delimiter, context, invocation);
        }
        int lastIndex = this.lastIndexOfInRange(fullView, range);
        if (lastIndex == -1) {
            lastIndex = fullView.length() - 1;
        }
        String rest = fullView.claim(0, lastIndex + 1);
        SuggestionContext suggestionContext = new SuggestionContext(rest);
        int beforeConsumed = suggestionContext.getConsumed();
        SuggestionResult suggestionResult = suggester.suggest(invocation, argument, suggestionContext);
        int afterConsumed = suggestionContext.getConsumed();
        if (afterConsumed < beforeConsumed) {
            throw new IllegalStateException("Suggester consumed more than before: " + afterConsumed + " < " + beforeConsumed + " for: " + argument.getKey() + " suggester: " + suggester.getClass().getName());
        }
        String base = current.multilevel();
        String baseWithoutRight = base.substring(0, base.length() - rest.length());
        SuggestionResult result = suggestionResult.appendLeftDirectly(baseWithoutRight);
        int count = suggestionContext.getCurrent().lengthMultilevel();
        if (range.isBelowRange(count)) {
            return result;
        }
        if (range.isInRange(count) && this.isMatch(parser, argument, invocation, rest)) {
            result.add(Suggestion.of(base));
            if (!rest.isEmpty()) {
                result.add(Suggestion.of(base + delimiter));
            }
        }
        if (range.isAboveRange(count)) {
            int margin = count - range.getMax();
            context.setConsumed(context.getConsumed() - margin);
        }
        return result;
    }

    private <T> boolean isMatch(Parser<SENDER, T> parser, Argument<T> argument, Invocation<SENDER> invocation, String rawArgument) {
        return parser.match(invocation, argument, RawInput.of(StringUtil.splitBySpace(rawArgument)));
    }

    @Nullable
    private RawInputView findNextElementView(RawInputView rawInputView, Range argumentRange, String delimiter) {
        int min = argumentRange.getMin();
        int max = argumentRange.getMax();
        int delimiterLength = delimiter.length();
        int lastDelimiterIndex = -1;
        do {
            if ((lastDelimiterIndex = rawInputView.indexOf(delimiter, lastDelimiterIndex == -1 ? 0 : lastDelimiterIndex + delimiterLength)) == -1) {
                return null;
            }
            RawInputView sub = rawInputView.sub(0, lastDelimiterIndex += delimiterLength);
            RawInputView subWithoutDelimiter = rawInputView.sub(0, lastDelimiterIndex - delimiterLength);
            int argumentCount = 1 + subWithoutDelimiter.countOf(' ');
            if (argumentCount > max) {
                return null;
            }
            if (argumentCount < min) continue;
            return sub;
        } while (lastDelimiterIndex != -1);
        return null;
    }

    protected <E> TypeToken<E> getElementType(VarargsProfile varargsProfile) {
        return varargsProfile.getElementType();
    }

    private static class SuccessRequirementCondition
    implements RequirementCondition {
        private final Object failedReason;

        private SuccessRequirementCondition(Object failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public Optional<FailedReason> check(Invocation<?> ignored, CommandExecutorMatchResult result) {
            if (result.isSuccessful()) {
                return Optional.empty();
            }
            return Optional.of(FailedReason.of(this.failedReason));
        }
    }
}

