/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.NamedParseableInput;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.NamedTypedParseableInput;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.RawParseableInput;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.Input;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface ParseableInput<MATCHER extends ParseableInputMatcher<MATCHER>>
extends Input<MATCHER> {
    public static NamedBuilder namedBuilder() {
        return new NamedBuilder();
    }

    public static RawBuilder rawBuilder() {
        return new RawBuilder();
    }

    public static ParseableInput<?> raw(String ... rawArguments) {
        return new RawParseableInput(Arrays.asList(rawArguments));
    }

    public static ParseableInput<?> raw(List<String> rawArguments) {
        return new RawParseableInput(rawArguments);
    }

    public static class RawBuilder {
        private final List<String> routes = new ArrayList<String>();

        public RawBuilder literal(String route) {
            this.routes.add(route);
            return this;
        }

        public RawBuilder rawArgument(String value) {
            this.routes.add(value);
            return this;
        }

        public ParseableInput<?> build() {
            return new RawParseableInput(this.routes);
        }
    }

    public static class NamedBuilder {
        private final List<String> routes = new ArrayList<String>();
        private final Map<String, String> namedArguments = new LinkedHashMap<String, String>();
        private final Map<String, Object> typedNamedArguments = new LinkedHashMap<String, Object>();
        private boolean isTyped = false;

        public NamedBuilder literal(String route) {
            this.routes.add(route);
            return this;
        }

        public NamedBuilder namedArgument(String name, String value) {
            this.namedArguments.put(name, value);
            this.typedNamedArguments.put(name, value);
            return this;
        }

        public <T> NamedBuilder namedTypedArgument(String name, T value) {
            this.typedNamedArguments.put(name, value);
            this.isTyped = true;
            return this;
        }

        public ParseableInput<?> build() {
            if (this.isTyped) {
                return new NamedTypedParseableInput(this.routes, this.typedNamedArguments);
            }
            return new NamedParseableInput(this.routes, this.namedArguments);
        }
    }
}

