/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.ArgumentKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.SimpleArgument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfile;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfileNamespace;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.PrioritizedList;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeToken;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.Requirement;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

public interface Argument<T>
extends Requirement<T> {
    @Override
    public String getName();

    public ArgumentKey getKey();

    public Optional<ParseResult<T>> getDefaultValue();

    @Deprecated
    default public Optional<ParseResult<T>> defaultValue() {
        return this.getDefaultValue();
    }

    public boolean hasDefaultValue();

    @ApiStatus.Experimental
    public <P> Optional<P> getProfile(ArgumentProfileNamespace<P> var1);

    @ApiStatus.Experimental
    public PrioritizedList<ArgumentProfile<?>> getProfiles();

    @ApiStatus.Experimental
    public <NEW> Argument<NEW> child(TypeToken<NEW> var1);

    @ApiStatus.Experimental
    public Argument<T> withoutProfile(ArgumentProfileNamespace<?> var1);

    public static <T> Argument<T> of(String name, Class<T> type) {
        return new SimpleArgument<T>(name, TypeToken.of(type));
    }

    @Deprecated
    public static <T> Argument<T> of(String name, Class<T> type, boolean nullable) {
        return new SimpleArgument<T>(name, TypeToken.of(type), nullable);
    }

    public static <T> Argument<T> of(String name, TypeToken<T> type) {
        return new SimpleArgument<T>(name, type);
    }

    @Deprecated
    public static <T> Argument<T> of(String name, TypeToken<T> type, boolean nullable) {
        return new SimpleArgument<T>(name, type, nullable);
    }

    @ApiStatus.Experimental
    public static <T, P extends ArgumentProfile<P>> Argument<T> profiled(String name, Class<T> type, P profile) {
        return Argument.profiled(name, TypeToken.of(type), profile);
    }

    @ApiStatus.Experimental
    public static <T, P extends ArgumentProfile<P>> Argument<T> profiled(String name, TypeToken<T> type, P profile) {
        return new SimpleArgument<T>(name, type).addProfile((ArgumentProfile)profile);
    }
}

