/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommandsInternal;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommandsProvider;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.AnnotationProcessorService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.InstanceSource;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.InstanceSourceProcessor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.inject.Injector;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.validator.method.MethodValidatorService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.builder.CommandBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LiteCommandsAnnotations<SENDER>
implements LiteCommandsProvider<SENDER> {
    private final List<Object> commandInstances;
    private final List<Class<?>> commandClasses;
    private final AnnotationProcessorService<SENDER> annotationProcessorService;
    private final MethodValidatorService<SENDER> validatorService;

    private LiteCommandsAnnotations(AnnotationProcessorService<SENDER> annotationProcessorService, MethodValidatorService<SENDER> validatorService) {
        this.annotationProcessorService = annotationProcessorService;
        this.validatorService = validatorService;
        this.commandInstances = new ArrayList<Object>();
        this.commandClasses = new ArrayList();
    }

    private LiteCommandsAnnotations() {
        this(AnnotationProcessorService.defaultService(), new MethodValidatorService());
    }

    public AnnotationProcessorService<SENDER> getAnnotationProcessorService() {
        return this.annotationProcessorService;
    }

    public MethodValidatorService<SENDER> getValidatorService() {
        return this.validatorService;
    }

    @Override
    public List<CommandBuilder<SENDER>> provide(LiteCommandsInternal<SENDER, ?> builder) {
        InstanceSourceProcessor processor = new InstanceSourceProcessor(this.annotationProcessorService, this.validatorService);
        Injector injector = new Injector(builder.getBindRegistry());
        ArrayList<Object> instances = new ArrayList<Object>(this.commandInstances);
        for (Class<?> commandClass : this.commandClasses) {
            Object instance2 = injector.createInstance(commandClass);
            instances.add(instance2);
        }
        return instances.stream().map(instance -> processor.processBuilder(new InstanceSource(instance))).collect(Collectors.toList());
    }

    public LiteCommandsAnnotations<SENDER> load(Object ... commands) {
        this.commandInstances.addAll(Arrays.asList(commands));
        return this;
    }

    public LiteCommandsAnnotations<SENDER> loadClasses(Class<?> ... commands) {
        this.commandClasses.addAll(Arrays.asList(commands));
        return this;
    }

    public static <SENDER> LiteCommandsAnnotations<SENDER> create() {
        return new LiteCommandsAnnotations<SENDER>();
    }

    public static <SENDER> LiteCommandsAnnotations<SENDER> of(Object ... commands) {
        return new LiteCommandsAnnotations<SENDER>().load(commands);
    }

    public static <SENDER> LiteCommandsAnnotations<SENDER> ofClasses(Class<?> ... commands) {
        return new LiteCommandsAnnotations<SENDER>().loadClasses(commands);
    }
}

