/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.AnnotationProcessorService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.ClassInvoker;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.InstanceSource;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.MethodInvoker;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.validator.method.MethodValidatorService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.ReflectUtil;
import java.lang.reflect.Method;

class InstanceSourceProcessor<SENDER> {
    private final AnnotationProcessorService<SENDER> annotationProcessorService;
    private final MethodValidatorService<SENDER> validatorService;

    public InstanceSourceProcessor(AnnotationProcessorService<SENDER> annotationProcessorService, MethodValidatorService<SENDER> validatorService) {
        this.annotationProcessorService = annotationProcessorService;
        this.validatorService = validatorService;
    }

    public CommandBuilder<SENDER> processBuilder(InstanceSource source) {
        Object instance = source.getInstance();
        Class<?> type = instance.getClass();
        CommandBuilder context = CommandBuilder.create().applyMeta(meta -> meta.list(Meta.COMMAND_ORIGIN_TYPE, list -> list.add(type)));
        ClassInvoker classInvoker = new ClassInvoker(type, context);
        context = this.annotationProcessorService.process(classInvoker);
        for (Method method : ReflectUtil.getMethods(type)) {
            MethodInvoker<SENDER> methodInvoker = new MethodInvoker<SENDER>(this.annotationProcessorService, this.validatorService, instance, method, context);
            context = this.annotationProcessorService.process(methodInvoker);
        }
        return context;
    }
}

