/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.sound;

import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.NoticeKey;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeResolver;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeSerdesResult;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.sound.SoundAdventure;
import com.github.imdmk.automessage.lib.net.kyori.adventure.audience.Audience;
import com.github.imdmk.automessage.lib.net.kyori.adventure.key.Key;
import com.github.imdmk.automessage.lib.net.kyori.adventure.sound.Sound;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.Optional;

public class SoundAdventureResolver
implements NoticeResolver<SoundAdventure> {
    private static final String MUSIC_WITH_CATEGORY = "%s %s %s %s";
    private static final String MUSIC_WITHOUT_CATEGORY = "%s %s %s";
    private final NoticeKey<SoundAdventure> key = NoticeKey.SOUND;

    @Override
    public NoticeKey<SoundAdventure> noticeKey() {
        return this.key;
    }

    @Override
    public void send(Audience audience, ComponentSerializer<Component, Component, String> componentSerializer, SoundAdventure content) {
        if (content.category() == null) {
            audience.playSound(Sound.sound(content.sound(), Sound.Source.MASTER, content.volume(), content.pitch()));
            return;
        }
        audience.playSound(Sound.sound(content.sound(), content.category(), content.volume(), content.pitch()));
    }

    @Override
    public NoticeSerdesResult serialize(SoundAdventure content) {
        if (content.category() == null) {
            return new NoticeSerdesResult.Single(String.format(MUSIC_WITHOUT_CATEGORY, content.sound().value(), Float.valueOf(content.pitch()), Float.valueOf(content.volume())));
        }
        return new NoticeSerdesResult.Single(String.format(MUSIC_WITH_CATEGORY, content.sound().value(), content.category().name(), Float.valueOf(content.pitch()), Float.valueOf(content.volume())));
    }

    @Override
    public Optional<SoundAdventure> deserialize(NoticeSerdesResult result) {
        Optional<String> firstElement = result.firstElement();
        if (firstElement.isEmpty()) {
            return Optional.empty();
        }
        String[] music = firstElement.get().split(" ");
        if (music.length < 3 || music.length > 4) {
            throw new IllegalStateException("Invalid music format: " + firstElement.get());
        }
        Key sound = Key.key("minecraft", music[0]);
        Sound.Source category = music.length == 3 ? null : Sound.Source.valueOf(music[1]);
        float pitch = Float.parseFloat(music[music.length - 2]);
        float volume = Float.parseFloat(music[music.length - 1]);
        return Optional.of(new SoundAdventure(sound, category, pitch, volume));
    }
}

