/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.com.eternalcode.gitcheck.github;

import com.github.imdmk.automessage.lib.com.eternalcode.gitcheck.git.GitTag;
import com.github.imdmk.automessage.lib.org.json.simple.JSONObject;
import java.time.Instant;
import java.util.NoSuchElementException;

final class JSONUtil {
    private JSONUtil() {
    }

    static String asString(JSONObject jsonObject, String key) {
        return JSONUtil.as(jsonObject, key, String.class);
    }

    static GitTag asGitTag(JSONObject jsonObject, String key) {
        String rawTag = JSONUtil.as(jsonObject, key, String.class);
        return GitTag.of(rawTag);
    }

    static Instant asInstant(JSONObject jsonObject, String key) {
        String rawDateTime = JSONUtil.as(jsonObject, key, String.class);
        return Instant.parse(rawDateTime);
    }

    private static <T> T as(JSONObject jsonObject, String key, Class<T> clazz) {
        Object obj = jsonObject.get(key);
        if (obj == null) {
            throw new NoSuchElementException("No value for key " + key);
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Value for key " + key + " is not of type " + clazz.getSimpleName());
        }
        return clazz.cast(obj);
    }
}

