/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.com.eternalcode.gitcheck;

import com.github.imdmk.automessage.lib.com.eternalcode.gitcheck.git.GitRelease;
import com.github.imdmk.automessage.lib.com.eternalcode.gitcheck.git.GitTag;
import com.github.imdmk.automessage.lib.com.eternalcode.gitcheck.shared.Preconditions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GitCheckResult {
    private final GitRelease latestRelease;
    private final GitTag currentTag;

    @ApiStatus.Internal
    GitCheckResult(@NotNull GitRelease latestRelease, @NotNull GitTag currentTag) {
        Preconditions.notNull(latestRelease, "latest release");
        Preconditions.notNull(currentTag, "current tag");
        this.latestRelease = latestRelease;
        this.currentTag = currentTag;
    }

    @NotNull
    public GitRelease getLatestRelease() {
        return this.latestRelease;
    }

    @NotNull
    public GitTag getCurrentTag() {
        return this.currentTag;
    }

    @Contract(pure=true)
    public boolean isUpToDate() {
        return this.latestRelease.getTag().equals(this.currentTag);
    }
}

