/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.message.auto.dispatcher;

import com.github.imdmk.automessage.configuration.ConfigurationManager;
import com.github.imdmk.automessage.feature.message.MessageService;
import com.github.imdmk.automessage.feature.message.auto.AutoMessageConfiguration;
import com.github.imdmk.automessage.feature.message.auto.AutoMessageMode;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.scheduler.TaskScheduler;
import com.github.imdmk.automessage.util.CollectionUtil;
import com.github.imdmk.automessage.util.DurationUtil;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class AutoMessageDispatcher {
    private final ConfigurationManager configurationManager;
    private final AutoMessageConfiguration configuration;
    private final MessageService messageService;
    private final TaskScheduler taskScheduler;
    private final AtomicInteger position = new AtomicInteger(0);
    private volatile long delayTicks;
    private volatile int currentTask;

    public AutoMessageDispatcher(@NotNull ConfigurationManager configurationManager, @NotNull AutoMessageConfiguration configuration, @NotNull MessageService messageService, @NotNull TaskScheduler taskScheduler) {
        this.configurationManager = Objects.requireNonNull(configurationManager, "configurationManager cannot be null");
        this.configuration = Objects.requireNonNull(configuration, "configuration cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler cannot be null");
        this.delayTicks = DurationUtil.toTicks(this.configuration.delay);
    }

    public void dispatch() {
        Notice message = this.selectMessage();
        this.messageService.create().onlinePlayers().notice(message).sendAsync();
    }

    public void dispatch(@NotNull Notice message) {
        this.messageService.create().onlinePlayers().notice(message).sendAsync();
    }

    public void changeDelay(long newDelayTicks) {
        if (newDelayTicks <= 0L) {
            throw new IllegalArgumentException("Delay must be positive");
        }
        if (this.delayTicks == newDelayTicks) {
            return;
        }
        this.configuration.delay = DurationUtil.fromTicks(newDelayTicks);
        this.configurationManager.save(this.configuration);
        this.delayTicks = newDelayTicks;
        this.schedule();
    }

    public synchronized void schedule() {
        if (this.currentTask > 0) {
            this.taskScheduler.cancelTask(this.currentTask);
        }
        BukkitTask task = this.taskScheduler.runTimerAsync(this::dispatch, 0L, this.delayTicks);
        this.currentTask = task.getTaskId();
    }

    @NotNull
    private Notice selectMessage() {
        List<Notice> messages = this.configuration.messages;
        return switch (this.configuration.mode) {
            default -> throw new IncompatibleClassChangeError();
            case AutoMessageMode.RANDOM -> CollectionUtil.getRandom(messages).orElseThrow(() -> new IllegalStateException("No messages available for random selection"));
            case AutoMessageMode.SEQUENTIAL -> {
                int index = this.position.getAndIncrement() % messages.size();
                yield CollectionUtil.select(messages, index).orElseThrow(() -> new IllegalStateException("No message at position: " + index));
            }
        };
    }

    @NotNull
    public Duration getDelay() {
        return DurationUtil.fromTicks(this.delayTicks);
    }
}

