/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.message.auto;

import com.github.imdmk.automessage.configuration.ConfigSection;
import com.github.imdmk.automessage.feature.message.auto.AutoMessageMode;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeResolverDefaults;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.okaeri.MultificationSerdesPack;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.annotation.Comment;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.commons.SerdesCommons;
import com.github.imdmk.automessage.lib.net.kyori.adventure.bossbar.BossBar;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AutoMessageConfiguration
extends ConfigSection {
    @Comment(value={"# How often should automatic messages be sent?"})
    public Duration delay = Duration.ofSeconds(10L);
    @Comment(value={"# Defines the selection strategy for automatic messages.", "# RANDOM - messages are chosen randomly.", "# SEQUENTIAL - messages are sent in order."})
    public AutoMessageMode mode = AutoMessageMode.SEQUENTIAL;
    @Comment(value={"# List of automatic messages to be dispatched.", "# Supports different Notice types like chat, actionbar, title, boss bar."})
    public List<Notice> messages = Arrays.asList(Notice.chat("<dark_gray>[<red>!<dark_gray>] <gray>This is first announcement of <rainbow>automessage <gray>plugin!"), Notice.actionbar("<dark_gray>[<yellow>!<dark_gray>] <gray>This is second announcement of <rainbow>automessage <gray>plugin!"), Notice.title("<dark_gray>[<red>!<dark_gray>]", "<rainbow>This is third announcement!"), Notice.bossBar(BossBar.Color.RED, BossBar.Overlay.PROGRESS, Duration.ofSeconds(5L), "<dark_gray>[<red><bold>!<dark_gray>] <rainbow>This is fourth announcement!"));

    @Override
    @NotNull
    public OkaeriSerdesPack getSerdesPack() {
        return registry -> {
            registry.register(new SerdesCommons());
            registry.register(new MultificationSerdesPack(NoticeResolverDefaults.createRegistry()));
        };
    }

    @Override
    @NotNull
    public String getFileName() {
        return "autoMessageConfiguration.yml";
    }
}

