/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.message;

import com.github.imdmk.automessage.feature.message.MessageConfiguration;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.adventure.AudienceConverter;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.bukkit.BukkitMultification;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.provider.NoticeProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.translation.TranslationProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.platform.AudienceProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MessageService
extends BukkitMultification<MessageConfiguration> {
    private final MessageConfiguration messageConfiguration;
    private final AudienceProvider audienceProvider;
    private final MiniMessage miniMessage;

    public MessageService(@NotNull MessageConfiguration messageConfiguration, @NotNull AudienceProvider audienceProvider, @NotNull MiniMessage miniMessage) {
        this.messageConfiguration = Objects.requireNonNull(messageConfiguration, "messageConfiguration cannot be null");
        this.audienceProvider = Objects.requireNonNull(audienceProvider, "audienceProvider cannot be null");
        this.miniMessage = Objects.requireNonNull(miniMessage, "miniMessage cannot be null");
    }

    @Override
    @NotNull
    protected TranslationProvider<MessageConfiguration> translationProvider() {
        return locale -> this.messageConfiguration;
    }

    @Override
    @NotNull
    protected ComponentSerializer<Component, Component, String> serializer() {
        return this.miniMessage;
    }

    @Override
    @NotNull
    protected AudienceConverter<CommandSender> audienceConverter() {
        return commandSender -> {
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                return this.audienceProvider.player(player.getUniqueId());
            }
            return this.audienceProvider.console();
        };
    }

    public void send(CommandSender sender, NoticeProvider<MessageConfiguration> notice) {
        this.create().viewer(sender).notice(notice).send();
    }

    public void close() {
        this.audienceProvider.close();
    }
}

