/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.message;

import com.github.imdmk.automessage.configuration.ConfigSection;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeResolverDefaults;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.okaeri.MultificationSerdesPack;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.annotation.Comment;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import org.jetbrains.annotations.NotNull;

public class MessageConfiguration
extends ConfigSection {
    @Comment(value={"# Sent when the automatic message delay is changed", "# {DELAY} - New delay value"})
    public Notice autoMessageDelayChange = Notice.chat("<green>Changed auto message delay to {DELAY}.");
    @Comment(value={"# Sent when querying the current automatic message delay", "# {DELAY} - Current delay value"})
    public Notice autoMessageDelay = Notice.chat("<green>Current auto message delay is {DELAY}.");
    @Comment(value={"# Sent when a command is used incorrectly", "# {USAGE} - Correct command usage"})
    public Notice invalidCommandUsage = Notice.chat("<red>Invalid usage<dark_gray>: <red>{USAGE}");
    @Comment(value={"# Header for multiple valid usages of a command"})
    public Notice usageHeader = Notice.chat("<red>Invalid usage<dark_gray>:");
    @Comment(value={"# Entry in the list of valid usages", "# {USAGE} - Correct command usage"})
    public Notice usageEntry = Notice.chat("<dark_gray>- <red>{USAGE}");
    @Comment(value={"# Sent when command sender lacks required permissions", "# {PERMISSIONS} - Required permission nodes"})
    public Notice missingPermissions = Notice.chat("<red>Missing permissions<dark_gray>: <red>{PERMISSIONS}");
    @Comment(value={"# Sent when the player could not be found"})
    public Notice playerNotFound = Notice.chat("<red>Player not found<dark_gray>.");
    @Comment(value={"# Sent when successfully reloaded all plugin configuration files"})
    public Notice reload = Notice.chat("<green>The plugin configuration files has been reloaded. May note that not all functions are reloaded.");
    @Comment(value={"# Sent when there is an error loading plugin configuration files"})
    public Notice reloadError = Notice.chat("<red>Failed to reload plugin configuration files. Please see the console.");

    @Override
    @NotNull
    public OkaeriSerdesPack getSerdesPack() {
        return registry -> registry.register(new MultificationSerdesPack(NoticeResolverDefaults.createRegistry()));
    }

    @Override
    @NotNull
    public String getFileName() {
        return "messageConfiguration.yml";
    }
}

