/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.command.implementation;

import com.github.imdmk.automessage.configuration.ConfigurationManager;
import com.github.imdmk.automessage.feature.message.MessageService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Command(name="automessage reload")
@Permission(value={"command.automessage.reload"})
public class ReloadCommand {
    private final Logger logger;
    private final ConfigurationManager configurationManager;
    private final MessageService messageService;

    public ReloadCommand(@NotNull Logger logger, @NotNull ConfigurationManager configurationManager, @NotNull MessageService messageService) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.configurationManager = Objects.requireNonNull(configurationManager, "configurationManager cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
    }

    @Execute
    void reload(@Context CommandSender sender) {
        ((CompletableFuture)this.configurationManager.reloadAll().thenAccept(v -> this.messageService.send(sender, notice -> notice.reload))).exceptionally(throwable -> {
            this.messageService.send(sender, notice -> notice.reloadError);
            this.logger.log(Level.SEVERE, "Failed to reload plugin configuration.", (Throwable)throwable);
            return null;
        });
    }
}

