/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.feature.command.builder.player;

import com.github.imdmk.automessage.feature.message.MessageConfiguration;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerArgument
extends ArgumentResolver<CommandSender, Player> {
    private final Server server;
    private final MessageConfiguration messageConfiguration;

    public PlayerArgument(@NotNull Server server, @NotNull MessageConfiguration messageConfiguration) {
        this.server = Objects.requireNonNull(server, "server cannot be null");
        this.messageConfiguration = Objects.requireNonNull(messageConfiguration, "messageConfiguration cannot be null");
    }

    @Override
    protected ParseResult<Player> parse(Invocation<CommandSender> invocation, Argument<Player> context, String argument) {
        return Optional.ofNullable(this.server.getPlayer(argument)).map(ParseResult::success).orElseGet(() -> ParseResult.failure(this.messageConfiguration.playerNotFound));
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Player> argument, SuggestionContext context) {
        return this.server.getOnlinePlayers().stream().map(Player::getName).collect(SuggestionResult.collector());
    }
}

