/*
 * Decompiled with CFR 0.152.
 */
package io.github.illa4257.opensit;

import io.github.illa4257.opensit.OpenSit;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class OpenSitListener
implements Listener {
    public final Class<Event> dismountEvent;
    public final double offset;
    public final double offsetHalf;
    public final double offsetFull;

    public static void eachSit(Location l, RunnableBlockArg r) {
        double sy = (double)l.getBlockY() - 0.1;
        double ey = l.getBlockY() + 1;
        int sx = l.getBlockX();
        int sz = l.getBlockZ();
        int ex = sx + 1;
        int ez = sz + 1;
        for (Entity e : l.getChunk().getEntities()) {
            Location l2;
            if (!(e instanceof BlockDisplay) || !e.getScoreboardTags().contains("sit") && !e.getScoreboardTags().contains("sit2") || !((l2 = e.getLocation()).getY() > sy) || !(l2.getY() <= ey) || !(l2.getX() >= (double)sx) || !(l2.getX() <= (double)ex) || !(l2.getZ() >= (double)sz) || !(l2.getZ() <= (double)ez)) continue;
            r.run(e);
        }
    }

    public static void removeSitsInBlock(Location l) {
        double sy = (double)l.getBlockY() - 0.1;
        double ey = l.getBlockY() + 1;
        int sx = l.getBlockX();
        int sz = l.getBlockZ();
        int ex = sx + 1;
        int ez = sz + 1;
        for (Entity e : l.getChunk().getEntities()) {
            Location l2;
            if (!(e instanceof BlockDisplay) || !e.getScoreboardTags().contains("sit") && !e.getScoreboardTags().contains("sit2") || !((l2 = e.getLocation()).getY() > sy) || !(l2.getY() <= ey) || !(l2.getX() >= (double)sx) || !(l2.getX() <= (double)ex) || !(l2.getZ() >= (double)sz) || !(l2.getZ() <= (double)ez)) continue;
            e.remove();
        }
    }

    public OpenSitListener(OpenSit plugin) {
        Class<?> cl = null;
        double o = 0.0;
        try {
            cl = Class.forName("org.bukkit.event.entity.EntityDismountEvent");
            o = 0.2;
        }
        catch (Exception ex) {
            try {
                plugin.getLogger().info("Old server, I will use another event.");
                cl = Class.forName("org.spigotmc.event.entity.EntityDismountEvent");
            }
            catch (Exception ex1) {
                plugin.getLogger().warning(ex.toString());
            }
        }
        this.dismountEvent = cl;
        this.offset = o;
        this.offsetHalf = this.offset + 0.3;
        this.offsetFull = this.offsetHalf + 0.5;
    }

    public void register(OpenSit plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Method d = null;
        Method e = null;
        if (this.dismountEvent != null) {
            try {
                d = this.dismountEvent.getMethod("getDismounted", new Class[0]);
                e = this.dismountEvent.getMethod("getEntity", new Class[0]);
            }
            catch (Exception ex) {
                plugin.getLogger().warning(ex.toString());
            }
        }
        Method md = d;
        Method me = e;
        plugin.getServer().getPluginManager().registerEvent(this.dismountEvent, (Listener)this, EventPriority.LOWEST, (listener, event) -> {
            if (listener != this) {
                return;
            }
            if (!this.dismountEvent.isInstance(event)) {
                return;
            }
            try {
                Entity d = (Entity)md.invoke((Object)event, new Object[0]);
                Entity e = (Entity)me.invoke((Object)event, new Object[0]);
                if (d instanceof BlockDisplay) {
                    if (d.getScoreboardTags().contains("sit")) {
                        e.teleport(e.getLocation().add(0.0, 1.0, 0.0));
                    } else if (d.getScoreboardTags().contains("sit2")) {
                        e.teleport(e.getLocation().add(0.0, 1.5, 0.0));
                    } else {
                        return;
                    }
                    if (d.getPassengers().isEmpty()) {
                        d.remove();
                    }
                }
            }
            catch (Exception ex) {
                plugin.getLogger().warning(ex.toString());
            }
        }, (Plugin)plugin, true);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Block b = event.getClickedBlock();
        if (event.getItem() != null || b == null || event.getAction().isLeftClick() || !event.getPlayer().hasPermission("OpenSit.SitClick")) {
            return;
        }
        Location l = b.getLocation();
        Block b2 = b.getWorld().getBlockAt(l.getBlockX(), l.getBlockY() + 1, l.getBlockZ());
        if (b2.isSolid() && !(b2.getState().getBlockData() instanceof TrapDoor)) {
            return;
        }
        BlockData d = b.getState().getBlockData();
        if (d instanceof Slab || d instanceof Stairs) {
            boolean t = d instanceof Slab ? ((Slab)d).getType() != Slab.Type.BOTTOM : ((Stairs)d).getHalf() == Bisected.Half.TOP;
            BlockDisplay r = (BlockDisplay)l.getWorld().spawnEntity(new Location(l.getWorld(), l.getX() + 0.5, l.getY() + (t ? this.offsetFull : this.offsetHalf), l.getZ() + 0.5), EntityType.BLOCK_DISPLAY);
            r.addScoreboardTag(d instanceof Slab || t ? "sit" : "sit2");
            r.addPassenger((Entity)event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Entity e = event.getPlayer().getVehicle();
        if (e instanceof BlockDisplay && (e.getScoreboardTags().contains("sit") || e.getScoreboardTags().contains("sit2"))) {
            Location l = new Location(e.getWorld(), e.getLocation().getX(), e.getLocation().getY() + 0.2, e.getLocation().getZ());
            Block b = l.getWorld().getBlockAt(l.getBlockX(), l.getBlockY() + 1, l.getBlockZ());
            if (!l.getBlock().isSolid() && !l.getWorld().getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ()).isSolid() || b.isSolid() && !(b.getState().getBlockData() instanceof TrapDoor)) {
                e.remove();
            }
        }
    }

    @EventHandler
    public void onExplodeBlock(BlockExplodeEvent event) {
        for (Block b : event.blockList()) {
            OpenSitListener.removeSitsInBlock(b.getLocation());
        }
    }

    @EventHandler
    public void onExplodeBlock(EntityExplodeEvent event) {
        for (Block b : event.blockList()) {
            OpenSitListener.removeSitsInBlock(b.getLocation());
        }
    }

    public void moved(Vector d, List<Block> bl) {
        ArrayList el = new ArrayList();
        for (Block b : bl) {
            Location tl = b.getLocation().clone().add(d);
            Location ul = tl.clone().subtract(0.0, 1.0, 0.0);
            Location ul2 = tl.clone().add(0.0, 1.0, 0.0);
            if (!bl.contains(ul.getBlock()) && b.isSolid()) {
                OpenSitListener.removeSitsInBlock(ul);
            }
            if (!bl.contains(ul2.getBlock()) && ul2.getBlock().isSolid()) {
                OpenSitListener.removeSitsInBlock(b.getLocation());
                continue;
            }
            OpenSitListener.eachSit(b.getLocation(), e -> {
                if (el.contains(e)) {
                    return;
                }
                el.add(e);
                List lp = e.getPassengers();
                if (!lp.isEmpty()) {
                    BlockDisplay r = (BlockDisplay)b.getWorld().spawnEntity(e.getLocation().add(d), EntityType.BLOCK_DISPLAY);
                    for (String s : e.getScoreboardTags()) {
                        r.addScoreboardTag(s);
                    }
                    for (Entity p : lp) {
                        r.addPassenger(p);
                    }
                    el.add(r);
                }
                e.remove();
            });
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        this.moved(event.getDirection().getDirection(), event.getBlocks());
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (event.getDirection().getDirection().getY() == 0.0 && event.getBlocks().isEmpty()) {
            OpenSitListener.removeSitsInBlock(event.getBlock().getLocation().clone().add(event.getDirection().getDirection()));
        } else if (event.getDirection().getDirection().getY() < 0.0 && event.getBlocks().isEmpty()) {
            OpenSitListener.removeSitsInBlock(event.getBlock().getLocation().clone().subtract(0.0, 2.0, 0.0));
        }
        this.moved(event.getDirection().getDirection(), event.getBlocks());
    }

    @EventHandler
    public void onBreakBlock(BlockBreakEvent event) {
        OpenSitListener.removeSitsInBlock(event.getBlock().getLocation());
    }

    public static interface RunnableBlockArg {
        public void run(Entity var1);
    }
}

