/*
 * Decompiled with CFR 0.152.
 */
package your.plugin.shaded.org.apache.commons.net.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import your.plugin.shaded.org.apache.commons.net.MalformedServerReplyException;
import your.plugin.shaded.org.apache.commons.net.io.DotTerminatedMessageReader;
import your.plugin.shaded.org.apache.commons.net.io.DotTerminatedMessageWriter;
import your.plugin.shaded.org.apache.commons.net.nntp.Article;
import your.plugin.shaded.org.apache.commons.net.nntp.ArticleInfo;
import your.plugin.shaded.org.apache.commons.net.nntp.ArticleIterator;
import your.plugin.shaded.org.apache.commons.net.nntp.ArticlePointer;
import your.plugin.shaded.org.apache.commons.net.nntp.NNTP;
import your.plugin.shaded.org.apache.commons.net.nntp.NNTPReply;
import your.plugin.shaded.org.apache.commons.net.nntp.NewGroupsOrNewsQuery;
import your.plugin.shaded.org.apache.commons.net.nntp.NewsgroupInfo;
import your.plugin.shaded.org.apache.commons.net.nntp.NewsgroupIterator;
import your.plugin.shaded.org.apache.commons.net.nntp.ReplyIterator;
import your.plugin.shaded.org.apache.commons.net.util.NetConstants;

public class NNTPClient
extends NNTP {
    private static final NewsgroupInfo[] EMPTY_NEWSGROUP_INFO_ARRAY = new NewsgroupInfo[0];

    static Article parseArticleEntry(String line) {
        Article article = new Article();
        article.setSubject(line);
        String[] parts = line.split("\t");
        if (parts.length > 6) {
            int i = 0;
            try {
                article.setArticleNumber(Long.parseLong(parts[i++]));
                article.setSubject(parts[i++]);
                article.setFrom(parts[i++]);
                article.setDate(parts[i++]);
                article.setArticleId(parts[i++]);
                article.addReference(parts[i++]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return article;
    }

    private static void parseGroupReply(String reply, NewsgroupInfo info) throws MalformedServerReplyException {
        String[] tokens = reply.split(" ");
        if (tokens.length >= 5) {
            int i = 1;
            try {
                info.setArticleCount(Long.parseLong(tokens[i++]));
                info.setFirstArticle(Long.parseLong(tokens[i++]));
                info.setLastArticle(Long.parseLong(tokens[i++]));
                info.setNewsgroup(tokens[i++]);
                info.setPostingPermission(0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse newsgroup info.\nServer reply: " + reply);
    }

    static NewsgroupInfo parseNewsgroupListEntry(String entry) {
        String[] tokens = entry.split(" ");
        if (tokens.length < 4) {
            return null;
        }
        NewsgroupInfo result = new NewsgroupInfo();
        int i = 0;
        result.setNewsgroup(tokens[i++]);
        try {
            long lastNum = Long.parseLong(tokens[i++]);
            long firstNum = Long.parseLong(tokens[i++]);
            result.setFirstArticle(firstNum);
            result.setLastArticle(lastNum);
            if (firstNum == 0L && lastNum == 0L) {
                result.setArticleCount(0L);
            } else {
                result.setArticleCount(lastNum - firstNum + 1L);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (tokens[i++].charAt(0)) {
            case 'Y': 
            case 'y': {
                result.setPostingPermission(2);
                break;
            }
            case 'N': 
            case 'n': {
                result.setPostingPermission(3);
                break;
            }
            case 'M': 
            case 'm': {
                result.setPostingPermission(1);
                break;
            }
            default: {
                result.setPostingPermission(0);
            }
        }
        return result;
    }

    private void ai2ap(ArticleInfo ai, ArticlePointer ap) {
        if (ap != null) {
            ap.articleId = ai.articleId;
            ap.articleNumber = (int)ai.articleNumber;
        }
    }

    private ArticleInfo ap2ai(ArticlePointer ap) {
        if (ap == null) {
            return null;
        }
        ArticleInfo ai = new ArticleInfo();
        return ai;
    }

    public boolean authenticate(String username, String password) throws IOException {
        int replyCode = this.authinfoUser(username);
        if (replyCode == 381 && (replyCode = this.authinfoPass(password)) == 281) {
            this._isAllowedToPost = true;
            return true;
        }
        return false;
    }

    public boolean completePendingCommand() throws IOException {
        return NNTPReply.isPositiveCompletion(this.getReply());
    }

    public Writer forwardArticle(String articleId) throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.ihave(articleId))) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public Iterable<Article> iterateArticleInfo(long lowArticleNumber, long highArticleNumber) throws IOException {
        BufferedReader info = this.retrieveArticleInfo(lowArticleNumber, highArticleNumber);
        if (info == null) {
            throw new IOException("XOVER command failed: " + this.getReplyString());
        }
        return new ArticleIterator(new ReplyIterator(info, false));
    }

    public Iterable<String> iterateNewNews(NewGroupsOrNewsQuery query) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newnews(query.getNewsgroups(), query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWNEWS command failed: " + this.getReplyString());
    }

    public Iterable<String> iterateNewNewsgroupListing(NewGroupsOrNewsQuery query) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newgroups(query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWGROUPS command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewNewsgroups(NewGroupsOrNewsQuery query) throws IOException {
        return new NewsgroupIterator(this.iterateNewNewsgroupListing(query));
    }

    public Iterable<String> iterateNewsgroupListing() throws IOException {
        if (NNTPReply.isPositiveCompletion(this.list())) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST command failed: " + this.getReplyString());
    }

    public Iterable<String> iterateNewsgroupListing(String wildmat) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.listActive(wildmat))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST ACTIVE " + wildmat + " command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups() throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups(String wildmat) throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing(wildmat));
    }

    /*
     * Exception decompiling
     */
    public String listHelp() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] listNewNews(NewGroupsOrNewsQuery query) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newnews(query.getNewsgroups(), query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                list.addElement(line);
            }
        }
        int size = list.size();
        if (size < 1) {
            return NetConstants.EMPTY_STRING_ARRAY;
        }
        Object[] result = new String[size];
        list.copyInto(result);
        return result;
    }

    public NewsgroupInfo[] listNewNewsgroups(NewGroupsOrNewsQuery query) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newgroups(query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewsgroups() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.list())) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewsgroups(String wildmat) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.listActive(wildmat))) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public String[] listOverviewFmt() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand("LIST", "OVERVIEW.FMT"))) {
            return null;
        }
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                list.add(line);
            }
            String[] stringArray = list.toArray(NetConstants.EMPTY_STRING_ARRAY);
            return stringArray;
        }
    }

    public boolean logout() throws IOException {
        return NNTPReply.isPositiveCompletion(this.quit());
    }

    private void parseArticlePointer(String reply, ArticleInfo pointer) throws MalformedServerReplyException {
        String[] tokens = reply.split(" ");
        if (tokens.length >= 3) {
            int i = 1;
            try {
                pointer.articleNumber = Long.parseLong(tokens[i++]);
                pointer.articleId = tokens[i++];
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse article pointer.\nServer reply: " + reply);
    }

    public Writer postArticle() throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.post())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    private NewsgroupInfo[] readNewsgroupListing() throws IOException {
        Vector<NewsgroupInfo> list = new Vector<NewsgroupInfo>(2048);
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                NewsgroupInfo tmp = NNTPClient.parseNewsgroupListEntry(line);
                if (tmp == null) {
                    throw new MalformedServerReplyException(line);
                }
                list.addElement(tmp);
            }
        }
        int size = list.size();
        if (size < 1) {
            return EMPTY_NEWSGROUP_INFO_ARRAY;
        }
        Object[] info = new NewsgroupInfo[size];
        list.copyInto(info);
        return info;
    }

    private BufferedReader retrieve(int command, long articleNumber, ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand(command, Long.toString(articleNumber)))) {
            return null;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    private BufferedReader retrieve(int command, String articleId, ArticleInfo pointer) throws IOException {
        if (articleId != null ? !NNTPReply.isPositiveCompletion(this.sendCommand(command, articleId)) : !NNTPReply.isPositiveCompletion(this.sendCommand(command))) {
            return null;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public Reader retrieveArticle() throws IOException {
        return this.retrieveArticle(null);
    }

    @Deprecated
    public Reader retrieveArticle(int articleNumber) throws IOException {
        return this.retrieveArticle((long)articleNumber);
    }

    @Deprecated
    public Reader retrieveArticle(int articleNumber, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticle((long)articleNumber, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public BufferedReader retrieveArticle(long articleNumber) throws IOException {
        return this.retrieveArticle(articleNumber, null);
    }

    public BufferedReader retrieveArticle(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(0, articleNumber, pointer);
    }

    public Reader retrieveArticle(String articleId) throws IOException {
        return this.retrieveArticle(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticle(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(0, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticle(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticle(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public Reader retrieveArticleBody() throws IOException {
        return this.retrieveArticleBody(null);
    }

    @Deprecated
    public Reader retrieveArticleBody(int a) throws IOException {
        return this.retrieveArticleBody((long)a);
    }

    @Deprecated
    public Reader retrieveArticleBody(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        BufferedReader rdr = this.retrieveArticleBody((long)a, ai);
        this.ai2ap(ai, ap);
        return rdr;
    }

    public BufferedReader retrieveArticleBody(long articleNumber) throws IOException {
        return this.retrieveArticleBody(articleNumber, null);
    }

    public BufferedReader retrieveArticleBody(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(1, articleNumber, pointer);
    }

    public Reader retrieveArticleBody(String articleId) throws IOException {
        return this.retrieveArticleBody(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticleBody(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(1, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticleBody(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticleBody(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public Reader retrieveArticleHeader() throws IOException {
        return this.retrieveArticleHeader(null);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int a) throws IOException {
        return this.retrieveArticleHeader((long)a);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        BufferedReader rdr = this.retrieveArticleHeader((long)a, ai);
        this.ai2ap(ai, ap);
        return rdr;
    }

    public BufferedReader retrieveArticleHeader(long articleNumber) throws IOException {
        return this.retrieveArticleHeader(articleNumber, null);
    }

    public BufferedReader retrieveArticleHeader(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(3, articleNumber, pointer);
    }

    public Reader retrieveArticleHeader(String articleId) throws IOException {
        return this.retrieveArticleHeader(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticleHeader(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(3, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticleHeader(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticleHeader(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    @Deprecated
    public Reader retrieveArticleInfo(int lowArticleNumber) throws IOException {
        return this.retrieveArticleInfo((long)lowArticleNumber);
    }

    @Deprecated
    public Reader retrieveArticleInfo(int lowArticleNumber, int highArticleNumber) throws IOException {
        return this.retrieveArticleInfo((long)lowArticleNumber, (long)highArticleNumber);
    }

    public BufferedReader retrieveArticleInfo(long articleNumber) throws IOException {
        return this.retrieveArticleInfo(Long.toString(articleNumber));
    }

    public BufferedReader retrieveArticleInfo(long lowArticleNumber, long highArticleNumber) throws IOException {
        return this.retrieveArticleInfo(lowArticleNumber + "-" + highArticleNumber);
    }

    private BufferedReader retrieveArticleInfo(String articleRange) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xover(articleRange))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    @Deprecated
    public Reader retrieveHeader(String a, int b) throws IOException {
        return this.retrieveHeader(a, (long)b);
    }

    @Deprecated
    public Reader retrieveHeader(String header, int lowArticleNumber, int highArticleNumber) throws IOException {
        return this.retrieveHeader(header, (long)lowArticleNumber, (long)highArticleNumber);
    }

    public BufferedReader retrieveHeader(String header, long articleNumber) throws IOException {
        return this.retrieveHeader(header, Long.toString(articleNumber));
    }

    public BufferedReader retrieveHeader(String header, long lowArticleNumber, long highArticleNumber) throws IOException {
        return this.retrieveHeader(header, lowArticleNumber + "-" + highArticleNumber);
    }

    private BufferedReader retrieveHeader(String header, String articleRange) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xhdr(header, articleRange))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public boolean selectArticle(ArticleInfo pointer) throws IOException {
        return this.selectArticle(null, pointer);
    }

    @Deprecated
    public boolean selectArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    @Deprecated
    public boolean selectArticle(int a) throws IOException {
        return this.selectArticle((long)a);
    }

    @Deprecated
    public boolean selectArticle(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        boolean b = this.selectArticle((long)a, ai);
        this.ai2ap(ai, ap);
        return b;
    }

    public boolean selectArticle(long articleNumber) throws IOException {
        return this.selectArticle(articleNumber, null);
    }

    public boolean selectArticle(long articleNumber, ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.stat(articleNumber))) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    public boolean selectArticle(String articleId) throws IOException {
        return this.selectArticle(articleId, (ArticleInfo)null);
    }

    public boolean selectArticle(String articleId, ArticleInfo pointer) throws IOException {
        if (articleId != null ? !NNTPReply.isPositiveCompletion(this.stat(articleId)) : !NNTPReply.isPositiveCompletion(this.stat())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectArticle(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectArticle(articleId, ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    public boolean selectNewsgroup(String newsgroup) throws IOException {
        return this.selectNewsgroup(newsgroup, null);
    }

    public boolean selectNewsgroup(String newsgroup, NewsgroupInfo info) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.group(newsgroup))) {
            return false;
        }
        if (info != null) {
            NNTPClient.parseGroupReply(this.getReplyString(), info);
        }
        return true;
    }

    public boolean selectNextArticle() throws IOException {
        return this.selectNextArticle((ArticleInfo)null);
    }

    public boolean selectNextArticle(ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.next())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectNextArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectNextArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    public boolean selectPreviousArticle() throws IOException {
        return this.selectPreviousArticle((ArticleInfo)null);
    }

    public boolean selectPreviousArticle(ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.last())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectPreviousArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectPreviousArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }
}

