/*
 * Decompiled with CFR 0.152.
 */
package your.plugin.shaded.org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import your.plugin.shaded.org.apache.commons.net.ftp.FTPClientConfig;
import your.plugin.shaded.org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private static final String PRE_PARSE_REGEX = "(.*?);([0-9]+)\\s*.*";
    private final Pattern preparsePattern;

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
        try {
            this.preparsePattern = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*?);([0-9]+)\\s*.*");
        }
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }

    @Override
    public List<String> preParse(List<String> original) {
        Integer existing;
        String version;
        String name;
        Matcher _preparse_matcher_;
        MatchResult result;
        String entry;
        HashMap<String, Integer> existingEntries = new HashMap<String, Integer>();
        ListIterator<String> iter = original.listIterator();
        while (iter.hasNext()) {
            entry = iter.next().trim();
            result = null;
            _preparse_matcher_ = this.preparsePattern.matcher(entry);
            if (!_preparse_matcher_.matches()) continue;
            result = _preparse_matcher_.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            Integer nv = Integer.valueOf(version);
            existing = (Integer)existingEntries.get(name);
            if (null != existing && nv < existing) {
                iter.remove();
                continue;
            }
            existingEntries.put(name, nv);
        }
        while (iter.hasPrevious()) {
            entry = iter.previous().trim();
            result = null;
            _preparse_matcher_ = this.preparsePattern.matcher(entry);
            if (!_preparse_matcher_.matches()) continue;
            result = _preparse_matcher_.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            int nv = Integer.parseInt(version);
            existing = (Integer)existingEntries.get(name);
            if (null == existing || nv >= existing) continue;
            iter.remove();
        }
        return original;
    }
}

