/*
 * Decompiled with CFR 0.152.
 */
package tr.alperendemir.autoBackup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import your.plugin.shaded.org.apache.commons.net.PrintCommandListener;
import your.plugin.shaded.org.apache.commons.net.ftp.FTPReply;
import your.plugin.shaded.org.apache.commons.net.ftp.FTPSClient;

public class FTPUploader {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String remotePath;
    private final boolean useImplicitTLS;
    private final Logger logger;

    public FTPUploader(String host, int port, String username, String password, String remotePath, boolean useImplicitTLS, Logger logger) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.remotePath = remotePath;
        this.useImplicitTLS = useImplicitTLS;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadBackups(List<String> backupFiles) {
        if (backupFiles == null || backupFiles.isEmpty()) {
            this.logger.info("No backup files to upload.");
            return true;
        }
        FTPSClient ftpsClient = new FTPSClient(this.useImplicitTLS);
        boolean allUploadsSuccessful = true;
        try {
            ftpsClient.setConnectTimeout(30000);
            ftpsClient.setBufferSize(0x100000);
            ftpsClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
            this.connectToServer(ftpsClient);
            this.prepareRemoteDirectory(ftpsClient);
            for (String backupFile : backupFiles) {
                if (this.uploadSingleFile(ftpsClient, backupFile)) continue;
                allUploadsSuccessful = false;
            }
        }
        catch (IOException e) {
            this.logger.severe("FTP upload error: " + e.getMessage());
            allUploadsSuccessful = false;
        }
        finally {
            this.disconnectFromServer(ftpsClient);
        }
        return allUploadsSuccessful;
    }

    private void connectToServer(FTPSClient ftpsClient) throws IOException {
        this.logger.info("Connecting to FTP server...");
        ftpsClient.connect(this.host, this.port);
        if (!FTPReply.isPositiveCompletion(ftpsClient.getReplyCode())) {
            throw new IOException("FTP server refused connection. Reply code: " + ftpsClient.getReplyCode());
        }
        if (!ftpsClient.login(this.username, this.password)) {
            throw new IOException("FTP login failed. Check username/password.");
        }
        ftpsClient.execPBSZ(0L);
        ftpsClient.execPROT("P");
        ftpsClient.setFileType(2);
        ftpsClient.enterLocalPassiveMode();
        this.logger.info("Connected to FTP server with implicit TLS: " + this.useImplicitTLS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uploadSingleFile(FTPSClient ftpsClient, String localFilePath) {
        File localFile = new File(localFilePath);
        String remoteFileName = localFile.getName();
        try (FileInputStream fis = new FileInputStream(localFile);){
            this.logger.info("Uploading file: " + localFilePath);
            if (ftpsClient.storeFile(remoteFileName, fis)) {
                this.logger.info("Uploaded file successfully: " + remoteFileName);
                boolean bl = true;
                return bl;
            }
            this.logger.severe("Failed to upload file: " + remoteFileName);
            this.logger.info("Switching to active mode...");
            ftpsClient.enterLocalActiveMode();
            if (ftpsClient.storeFile(remoteFileName, fis)) {
                this.logger.info("Uploaded file successfully in active mode: " + remoteFileName);
                boolean bl = true;
                return bl;
            }
            this.logger.severe("Active mode also failed for file: " + remoteFileName);
            return false;
        }
        catch (IOException e) {
            this.logger.severe("Error uploading file: " + e.getMessage());
            return false;
        }
    }

    private void prepareRemoteDirectory(FTPSClient ftpsClient) throws IOException {
        if (!ftpsClient.changeWorkingDirectory(this.remotePath)) {
            if (ftpsClient.makeDirectory(this.remotePath)) {
                this.logger.info("Created remote directory: " + this.remotePath);
                ftpsClient.changeWorkingDirectory(this.remotePath);
            } else {
                throw new IOException("Failed to create or change to remote directory: " + this.remotePath);
            }
        }
    }

    private void disconnectFromServer(FTPSClient ftpsClient) {
        try {
            if (ftpsClient.isConnected()) {
                ftpsClient.logout();
                ftpsClient.disconnect();
                this.logger.info("Disconnected from FTP server.");
            }
        }
        catch (IOException e) {
            this.logger.severe("Error closing FTP connection: " + e.getMessage());
        }
    }
}

