/*
 * Decompiled with CFR 0.152.
 */
package tr.alperendemir.autoBackup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import tr.alperendemir.autoBackup.DropboxUploader;
import tr.alperendemir.autoBackup.FTPUploader;

public final class AutoBackup
extends JavaPlugin {
    private int backupFrequency;
    private int maxBackups;
    private String backupPath;
    private List<String> worlds;
    private boolean ftpEnabled;
    private FTPUploader ftpUploader;
    private boolean dropboxEnabled;
    private DropboxUploader dropboxUploader;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        File backupDir = new File(this.backupPath);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
            this.getLogger().info("Backup directory created at: " + backupDir.getAbsolutePath());
        }
        this.startBackupTask();
        this.getLogger().info("AutoBackup plugin enabled! Backing up every " + this.backupFrequency + " seconds.");
    }

    public void onDisable() {
        this.getLogger().info("AutoBackup plugin disabled!");
    }

    private void loadConfigValues() {
        this.backupFrequency = this.getConfig().getInt("backup-frequency", 3600);
        this.maxBackups = this.getConfig().getInt("max-backups", 5);
        this.backupPath = this.getConfig().getString("backup-path", "backups");
        this.worlds = this.getConfig().getStringList("worlds");
        this.ftpEnabled = this.getConfig().getBoolean("ftp.enabled", false);
        if (this.ftpEnabled) {
            this.ftpUploader = new FTPUploader(this.getConfig().getString("ftp.host", ""), this.getConfig().getInt("ftp.port", 990), this.getConfig().getString("ftp.username", ""), this.getConfig().getString("ftp.password", ""), this.getConfig().getString("ftp.remote-path", "/backups"), this.getConfig().getBoolean("ftp.use-implicit-tls", true), this.getLogger());
        }
        this.dropboxEnabled = this.getConfig().getBoolean("dropbox.enabled", false);
        if (this.dropboxEnabled) {
            this.dropboxUploader = new DropboxUploader(this.getConfig().getString("dropbox.access-token", ""), this.getConfig().getString("dropbox.remote-path", "/backups"), this.getLogger());
        }
    }

    private void startBackupTask() {
        new BukkitRunnable(){

            public void run() {
                AutoBackup.this.performBackup();
            }
        }.runTaskTimerAsynchronously((Plugin)this, 0L, (long)this.backupFrequency * 20L);
    }

    private void performBackup() {
        this.getLogger().info("Starting backup process...");
        ArrayList<String> backupFiles = new ArrayList<String>();
        for (String worldName : this.worlds) {
            File worldDir = new File(worldName);
            if (worldDir.exists() && worldDir.isDirectory()) {
                String backupFileName = this.backupPath + "/" + worldName + "_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip";
                try {
                    this.zipDirectory(worldDir.toPath(), Paths.get(backupFileName, new String[0]));
                    backupFiles.add(backupFileName);
                    this.getLogger().info("Backed up world: " + worldName + " to " + backupFileName);
                }
                catch (IOException e) {
                    this.getLogger().severe("Failed to backup world: " + worldName + " - " + e.getMessage());
                }
                continue;
            }
            this.getLogger().warning("World directory not found: " + worldName);
        }
        if (this.ftpEnabled && this.ftpUploader != null) {
            this.ftpUploader.uploadBackups(backupFiles);
        }
        if (this.dropboxEnabled && this.dropboxUploader != null) {
            this.dropboxUploader.uploadBackups(backupFiles);
        }
        this.cleanupOldBackups();
        this.getLogger().info("Backup process completed.");
    }

    private void cleanupOldBackups() {
        File backupDir = new File(this.backupPath);
        if (!backupDir.exists() || !backupDir.isDirectory()) {
            return;
        }
        File[] backups = backupDir.listFiles((dir, name) -> name.endsWith(".zip"));
        if (backups == null) {
            return;
        }
        Arrays.sort(backups, Comparator.comparingLong(File::lastModified));
        int backupsToDelete = backups.length - this.maxBackups;
        for (int i = 0; i < backupsToDelete; ++i) {
            if (backups[i].delete()) {
                this.getLogger().info("Deleted old backup: " + backups[i].getName());
                continue;
            }
            this.getLogger().warning("Failed to delete old backup: " + backups[i].getName());
        }
    }

    private void zipDirectory(Path sourceDir, Path zipFilePath) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath.toFile()));
             Stream<Path> paths = Files.walk(sourceDir, new FileVisitOption[0]);){
            paths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> !path.getFileName().toString().equals("session.lock")).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourceDir.relativize((Path)path).toString());
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    Files.copy(path, zipOutputStream);
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    this.getLogger().severe("Error while zipping file: " + String.valueOf(path) + " - " + e.getMessage());
                }
            });
        }
    }
}

