/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools.config.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import lol.hyper.toolstats.ToolStats;

public class Version9 {
    private final ToolStats toolStats;

    public Version9(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void update() {
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config-8.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config-8.yml!", (Throwable)exception);
        }
        this.toolStats.logger.info("Updating config.yml to version 9.");
        this.toolStats.config.set("config-version", (Object)9);
        this.toolStats.logger.info("Adding new tokens configuration! Don't worry, this is disabled by default.");
        this.toolStats.logger.info("You can find more information here: https://github.com/hyperdefined/ToolStats/wiki/Token-System");
        this.toolStats.config.set("tokens.enabled", (Object)false);
        this.toolStats.config.set("tokens.craft-tokens", (Object)true);
        ArrayList<String> tokenComments = new ArrayList<String>();
        tokenComments.add("Use token system for tracking stats.");
        tokenComments.add("See https://github.com/hyperdefined/ToolStats/wiki/Token-System");
        this.toolStats.config.setComments("tokens", tokenComments);
        this.addToken("player-kills", "&7ToolStats: &8Player Kills Token", "&8Combine with a melee or ranged weapon in an anvil to track player kills.");
        this.addToken("mob-kills", "&7ToolStats: &8Mob Kills Token", "&8Combine with a melee or ranged weapon in an anvil to track mob kills.");
        this.addToken("blocks-mined", "&7ToolStats: &8Blocks Mined Token", "&8Combine with a pickaxe, axe, shovel, or shears in an anvil to track blocks mined.");
        this.addToken("crops-mined", "&7ToolStats: &8Crops Mined Token", "&8Combine with a hoe in an anvil to track crops broken.");
        this.addToken("fish-caught", "&7ToolStats: &8Fish Caught Token", "&8Combine with a fishing rod in an anvil to track fish caught.");
        this.addToken("sheep-sheared", "&7ToolStats: &8Sheep Sheared Token", "&8Combine with shears in an anvil to track sheep sheared.");
        this.addToken("damage-taken", "&7ToolStats: &8Damage Taken Token", "&8Combine with an armor piece in an anvil to track damage taken.");
        this.addToken("arrows-shot", "&7ToolStats: &8Arrows Shot Token", "&8Combine with a bow or crossbow in an anvil to track arrows shot.");
        this.addToken("flight-time", "&7ToolStats: &8Flight Time Token", "&8Combine with an elytra in an anvil to track flight time.");
        this.addToken("reset", "&7ToolStats: &8Reset Token", "&8Combine in an anvil with to reset ALL stats for this item. Tokens on this item stay.");
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config.yml!", (Throwable)exception);
        }
        this.toolStats.loadConfig();
        this.toolStats.logger.info("Config has been updated to version 9. A copy of version 8 has been saved as config-8.yml");
    }

    private void addToken(String tokenType, String title, String lore) {
        this.toolStats.logger.info("Adding token type configuration for {}", (Object)tokenType);
        this.toolStats.config.set("tokens.data." + tokenType + ".title", (Object)title);
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add(lore);
        this.toolStats.config.set("tokens.data." + tokenType + ".lore", loreList);
        this.toolStats.config.set("tokens.data." + tokenType + ".levels", (Object)1);
    }
}

