/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools.config.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import lol.hyper.toolstats.ToolStats;

public class Version8 {
    private final ToolStats toolStats;

    public Version8(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void update() {
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config-7.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config-7.yml!", (Throwable)exception);
        }
        this.toolStats.logger.info("Updating config.yml to version 8.");
        this.toolStats.config.set("config-version", (Object)8);
        this.toolStats.logger.info("Adding example for messages.mob.ZOMBIE");
        this.toolStats.config.set("messages.mob.ZOMBIE", (Object)"Zombie");
        this.toolStats.logger.info("Adding entry for enabled.created-by.mace");
        this.toolStats.config.set("enabled.created-by.mace", (Object)true);
        this.toolStats.logger.info("Adding entry for enabled.created-date.mace");
        this.toolStats.config.set("enabled.created-date.mace", (Object)true);
        this.toolStats.logger.info("Adding entry for enabled.player-kills.mace");
        this.toolStats.config.set("enabled.player-kills.mace", (Object)true);
        this.toolStats.logger.info("Adding entry for enabled.mob-kills.mace");
        this.toolStats.config.set("enabled.mob-kills.mace", (Object)true);
        ArrayList<String> mobComments = new ArrayList<String>();
        mobComments.add("Set display name for mobs. See: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/entity/EntityType.html");
        this.toolStats.config.setComments("messages.mob", mobComments);
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config.yml!", (Throwable)exception);
        }
        this.toolStats.loadConfig();
        this.toolStats.logger.info("Config has been updated to version 8. A copy of version 7 has been saved as config-7.yml");
    }
}

