/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lol.hyper.toolstats.ToolStats;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TokenData {
    private final ToolStats toolStats;
    private final Set<ShapedRecipe> recipes = new HashSet<ShapedRecipe>();
    private final ArrayList<String> tokenTypes = new ArrayList();

    public TokenData(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void setup() {
        NamespacedKey playerKillsKey = new NamespacedKey((Plugin)this.toolStats, "player-kills-token");
        ShapedRecipe playerKillRecipe = new ShapedRecipe(playerKillsKey, this.createToken("player-kills"));
        playerKillRecipe.shape(new String[]{" P ", "PSP", " P "});
        playerKillRecipe.setIngredient('P', Material.PAPER);
        playerKillRecipe.setIngredient('S', Material.WOODEN_SWORD);
        this.recipes.add(playerKillRecipe);
        NamespacedKey mobKillsKey = new NamespacedKey((Plugin)this.toolStats, "mob-kills-token");
        ShapedRecipe mobKillsRecipe = new ShapedRecipe(mobKillsKey, this.createToken("mob-kills"));
        mobKillsRecipe.shape(new String[]{" P ", "PRP", " P "});
        mobKillsRecipe.setIngredient('P', Material.PAPER);
        mobKillsRecipe.setIngredient('R', Material.ROTTEN_FLESH);
        this.recipes.add(mobKillsRecipe);
        NamespacedKey blocksMinedKey = new NamespacedKey((Plugin)this.toolStats, "blocks-mined-token");
        ShapedRecipe blocksMinedRecipe = new ShapedRecipe(blocksMinedKey, this.createToken("blocks-mined"));
        blocksMinedRecipe.shape(new String[]{" P ", "PSP", " P "});
        blocksMinedRecipe.setIngredient('P', Material.PAPER);
        blocksMinedRecipe.setIngredient('S', Material.WOODEN_PICKAXE);
        this.recipes.add(blocksMinedRecipe);
        NamespacedKey cropsMinedKey = new NamespacedKey((Plugin)this.toolStats, "crops-mined-token");
        ShapedRecipe cropsMinedRecipe = new ShapedRecipe(cropsMinedKey, this.createToken("crops-mined"));
        cropsMinedRecipe.shape(new String[]{" P ", "PHP", " P "});
        cropsMinedRecipe.setIngredient('P', Material.PAPER);
        cropsMinedRecipe.setIngredient('H', Material.WOODEN_HOE);
        this.recipes.add(cropsMinedRecipe);
        NamespacedKey fishCaughtKey = new NamespacedKey((Plugin)this.toolStats, "fish-caught-token");
        ShapedRecipe fishCaughtRecipe = new ShapedRecipe(fishCaughtKey, this.createToken("fish-caught"));
        fishCaughtRecipe.shape(new String[]{" P ", "PCP", " P "});
        fishCaughtRecipe.setIngredient('P', Material.PAPER);
        fishCaughtRecipe.setIngredient('C', Material.COD);
        this.recipes.add(fishCaughtRecipe);
        NamespacedKey sheepShearedKey = new NamespacedKey((Plugin)this.toolStats, "sheep-sheared-token");
        ShapedRecipe sheepShearedRecipe = new ShapedRecipe(sheepShearedKey, this.createToken("sheep-sheared"));
        sheepShearedRecipe.shape(new String[]{" P ", "PWP", " P "});
        sheepShearedRecipe.setIngredient('P', Material.PAPER);
        sheepShearedRecipe.setIngredient('W', Material.WHITE_WOOL);
        this.recipes.add(sheepShearedRecipe);
        NamespacedKey armorDamageKey = new NamespacedKey((Plugin)this.toolStats, "damage-taken-token");
        ShapedRecipe armorDamageRecipe = new ShapedRecipe(armorDamageKey, this.createToken("damage-taken"));
        armorDamageRecipe.shape(new String[]{" P ", "PCP", " P "});
        armorDamageRecipe.setIngredient('P', Material.PAPER);
        armorDamageRecipe.setIngredient('C', Material.LEATHER_CHESTPLATE);
        this.recipes.add(armorDamageRecipe);
        NamespacedKey damageDoneKey = new NamespacedKey((Plugin)this.toolStats, "damage-done-token");
        ShapedRecipe damageDoneRecipe = new ShapedRecipe(damageDoneKey, this.createToken("damage-done"));
        damageDoneRecipe.shape(new String[]{" P ", "PSP", " P "});
        damageDoneRecipe.setIngredient('P', Material.PAPER);
        damageDoneRecipe.setIngredient('S', Material.SHIELD);
        this.recipes.add(damageDoneRecipe);
        NamespacedKey arrowsShotKey = new NamespacedKey((Plugin)this.toolStats, "arrows-shot-token");
        ShapedRecipe arrowsShotRecipe = new ShapedRecipe(arrowsShotKey, this.createToken("arrows-shot"));
        arrowsShotRecipe.shape(new String[]{" P ", "PAP", " P "});
        arrowsShotRecipe.setIngredient('P', Material.PAPER);
        arrowsShotRecipe.setIngredient('A', Material.ARROW);
        this.recipes.add(arrowsShotRecipe);
        NamespacedKey flightTimeKey = new NamespacedKey((Plugin)this.toolStats, "flight-time-token");
        ShapedRecipe flightTimeRecipe = new ShapedRecipe(flightTimeKey, this.createToken("flight-time"));
        flightTimeRecipe.shape(new String[]{" P ", "PFP", " P "});
        flightTimeRecipe.setIngredient('P', Material.PAPER);
        flightTimeRecipe.setIngredient('F', Material.FEATHER);
        this.recipes.add(flightTimeRecipe);
        NamespacedKey resetKey = new NamespacedKey((Plugin)this.toolStats, "reset-token");
        ShapedRecipe resetRecipe = new ShapedRecipe(resetKey, this.createToken("reset"));
        resetRecipe.shape(new String[]{" P ", "PPP", " P "});
        resetRecipe.setIngredient('P', Material.PAPER);
        this.recipes.add(resetRecipe);
        NamespacedKey removeKey = new NamespacedKey((Plugin)this.toolStats, "remove-token");
        ShapedRecipe removeRecipe = new ShapedRecipe(removeKey, this.createToken("remove"));
        removeRecipe.shape(new String[]{" P ", "P P", " P "});
        removeRecipe.setIngredient('P', Material.PAPER);
        this.recipes.add(removeRecipe);
        NamespacedKey witherKillsKey = new NamespacedKey((Plugin)this.toolStats, "wither-kills-token");
        ShapedRecipe witherKillsRecipe = new ShapedRecipe(witherKillsKey, this.createToken("wither-kills"));
        witherKillsRecipe.shape(new String[]{" P ", "PWP", " P "});
        witherKillsRecipe.setIngredient('P', Material.PAPER);
        witherKillsRecipe.setIngredient('W', Material.WITHER_ROSE);
        this.recipes.add(witherKillsRecipe);
        NamespacedKey enderDragonKillsKey = new NamespacedKey((Plugin)this.toolStats, "enderdragon-kills-token");
        ShapedRecipe enderDragonKillsRecipe = new ShapedRecipe(enderDragonKillsKey, this.createToken("enderdragon-kills"));
        enderDragonKillsRecipe.shape(new String[]{" P ", "PEP", " P "});
        enderDragonKillsRecipe.setIngredient('P', Material.PAPER);
        enderDragonKillsRecipe.setIngredient('E', Material.ENDER_PEARL);
        this.recipes.add(enderDragonKillsRecipe);
        NamespacedKey criticalStrikesKey = new NamespacedKey((Plugin)this.toolStats, "critical-strikes-token");
        ShapedRecipe criticalStrikesRecipe = new ShapedRecipe(criticalStrikesKey, this.createToken("critical-strikes"));
        criticalStrikesRecipe.shape(new String[]{" P ", "PSP", " P "});
        criticalStrikesRecipe.setIngredient('P', Material.PAPER);
        criticalStrikesRecipe.setIngredient('S', Material.GOLDEN_SWORD);
        this.recipes.add(criticalStrikesRecipe);
        NamespacedKey tridentThrowsKey = new NamespacedKey((Plugin)this.toolStats, "trident-throws-token");
        ShapedRecipe tridentThrowsRecipe = new ShapedRecipe(tridentThrowsKey, this.createToken("trident-throws"));
        tridentThrowsRecipe.shape(new String[]{" P ", "PSP", " P "});
        tridentThrowsRecipe.setIngredient('P', Material.PAPER);
        tridentThrowsRecipe.setIngredient('S', Material.PRISMARINE_SHARD);
        this.recipes.add(tridentThrowsRecipe);
        this.tokenTypes.add("crops-mined");
        this.tokenTypes.add("blocks-mined");
        this.tokenTypes.add("damage-taken");
        this.tokenTypes.add("damage-done");
        this.tokenTypes.add("mob-kills");
        this.tokenTypes.add("player-kills");
        this.tokenTypes.add("arrows-shot");
        this.tokenTypes.add("sheep-sheared");
        this.tokenTypes.add("flight-time");
        this.tokenTypes.add("fish-caught");
        this.tokenTypes.add("reset");
        this.tokenTypes.add("remove");
        this.tokenTypes.add("wither-kills");
        this.tokenTypes.add("enderdragon-kills");
        this.tokenTypes.add("critical-strikes");
        this.tokenTypes.add("trident-throws");
    }

    public Set<ShapedRecipe> getRecipes() {
        return this.recipes;
    }

    public ArrayList<String> getTokenTypes() {
        return this.tokenTypes;
    }

    public ItemStack createToken(String tokenType) {
        Material material;
        ConfigurationSection tokenConfig = this.toolStats.config.getConfigurationSection("tokens.data." + tokenType);
        String materialFromConfig = tokenConfig.getString("material");
        if (materialFromConfig == null) {
            this.toolStats.logger.warn("Could not find material config for token {}", (Object)tokenType);
            this.toolStats.logger.warn("Using PAPER as default.");
            materialFromConfig = "PAPER";
        }
        if ((material = Material.getMaterial((String)materialFromConfig)) == null) {
            this.toolStats.logger.warn("Material {} is not a valid Minecraft material.", (Object)materialFromConfig);
            this.toolStats.logger.warn("Using PAPER as default.");
            material = Material.PAPER;
        }
        ItemStack token = new ItemStack(material);
        ItemMeta tokenMeta = token.getItemMeta();
        PersistentDataContainer tokenData = tokenMeta.getPersistentDataContainer();
        String titleFromConfig = this.toolStats.config.getString("tokens.data." + tokenType + ".title");
        Component title = this.toolStats.textUtils.format(titleFromConfig);
        List<Component> lore = this.toolStats.configTools.getTokenLore(tokenType);
        tokenMeta.displayName(title);
        tokenMeta.lore(lore);
        tokenData.set(this.toolStats.toolStatsKeys.getTokenType(), PersistentDataType.STRING, (Object)tokenType);
        token.setItemMeta(tokenMeta);
        if (tokenConfig.getBoolean("custom-model-data.enabled")) {
            String type = tokenConfig.getString("custom-model-data.type");
            Object value = tokenConfig.get("custom-model-data.value");
            if (type == null || value == null) {
                this.toolStats.logger.info("Could not find custom model data for token {}", (Object)tokenType);
                this.toolStats.logger.info("Type: {}", (Object)type);
                this.toolStats.logger.info("Value: {}", value);
                return null;
            }
            CustomModelData data = this.setData(type, value);
            if (data != null) {
                token.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)data);
            } else {
                return null;
            }
        }
        return token;
    }

    private CustomModelData setData(String type, Object data) {
        switch (type.toLowerCase(Locale.ROOT)) {
            case "float": {
                float f;
                try {
                    f = Float.parseFloat(data.toString());
                }
                catch (NumberFormatException e) {
                    this.toolStats.logger.info("{} is not a valid float!", data);
                    return null;
                }
                return (CustomModelData)CustomModelData.customModelData().addFloat(f).build();
            }
            case "string": {
                return (CustomModelData)CustomModelData.customModelData().addString(data.toString()).build();
            }
        }
        this.toolStats.logger.info("{} is not a valid data type!", data);
        return null;
    }
}

