/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ItemLore {
    private final ToolStats toolStats;

    public ItemLore(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public List<Component> updateItemLore(ItemMeta itemMeta, Component oldLine, Component newLine) {
        ArrayList<Component> itemLore;
        if (itemMeta.hasLore()) {
            itemLore = itemMeta.lore();
            for (int x = 0; x < itemLore.size(); ++x) {
                String line = PlainTextComponentSerializer.plainText().serialize((Component)itemLore.get(x));
                if (!line.equals(PlainTextComponentSerializer.plainText().serialize(oldLine))) continue;
                itemLore.set(x, newLine);
                return itemLore;
            }
            itemLore.add(newLine);
        } else {
            itemLore = new ArrayList<Component>();
            itemLore.add(newLine);
        }
        return itemLore;
    }

    public List<Component> removeLore(List<Component> inputLore, Component toRemove) {
        if (inputLore == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> newLore = new ArrayList<Component>(inputLore);
        newLore.removeIf(line -> PlainTextComponentSerializer.plainText().serialize(line).equals(PlainTextComponentSerializer.plainText().serialize(toRemove)));
        return newLore;
    }

    public ItemMeta updateCropsMined(ItemStack playerTool, int add) {
        String newTokens;
        ItemStack clone = playerTool.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.crops-harvested")) {
            if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested())) {
                String appliedTokens;
                Integer cropsMined = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER);
                if (cropsMined == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getCropsHarvested());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "crops-mined");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined);
                    Component lineToRemove = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", oldCropsMinedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "crops-mined");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer cropsMined = 0;
        if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER)) {
            cropsMined = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER);
        }
        if (cropsMined == null) {
            cropsMined = 0;
            this.toolStats.logger.warn("{} does not have valid crops-mined set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER, (Object)(cropsMined + add));
        String oldCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined);
        String newCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined + add);
        Component oldLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", oldCropsMinedFormatted);
        Component newLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", newCropsMinedFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateBlocksMined(ItemStack playerTool, int add) {
        String newTokens;
        ItemStack clone = playerTool.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "blocks-mined")) {
            if (container.has(this.toolStats.toolStatsKeys.getBlocksMined())) {
                String appliedTokens;
                Integer blocksMined = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER);
                if (blocksMined == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getBlocksMined());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "blocks-mined");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
                    Component lineToRemove = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", oldBlocksMinedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "blocks-mined");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getBlocksMined()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer blocksMined = 0;
        if (container.has(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER)) {
            blocksMined = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER);
        }
        if (blocksMined == null) {
            blocksMined = 0;
            this.toolStats.logger.warn("{} does not have valid generic-mined set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER, (Object)(blocksMined + add));
        String oldBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
        String newBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined + add);
        Component oldLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", oldBlocksMinedFormatted);
        Component newLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", newBlocksMinedFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updatePlayerKills(ItemStack playerWeapon, int add) {
        String newTokens;
        ItemStack clone = playerWeapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "player-kills")) {
            if (container.has(this.toolStats.toolStatsKeys.getPlayerKills())) {
                String appliedTokens;
                Integer playerKills = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER);
                if (playerKills == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getPlayerKills());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "player-kills");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
                    Component lineToRemove = this.toolStats.configTools.formatLore("player-kills", "{kills}", oldPlayerKillsFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "player-kills");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getPlayerKills()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer playerKills = 0;
        if (container.has(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER)) {
            playerKills = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER);
        }
        if (playerKills == null) {
            playerKills = 0;
            this.toolStats.logger.warn("{} does not have valid player-kills set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER, (Object)(playerKills + add));
        String oldPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
        String newPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills + add);
        Component oldLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", oldPlayerKillsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", newPlayerKillsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateMobKills(ItemStack playerWeapon, int add) {
        String newTokens;
        ItemStack clone = playerWeapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "mob-kills")) {
            if (container.has(this.toolStats.toolStatsKeys.getMobKills())) {
                String appliedTokens;
                Integer mobKills = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER);
                if (mobKills == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getMobKills());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "mob-kills");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
                    Component lineToRemove = this.toolStats.configTools.formatLore("mob-kills", "{kills}", oldMobKillsFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "mob-kills");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getMobKills()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer mobKills = 0;
        if (container.has(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER)) {
            mobKills = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER);
        }
        if (mobKills == null) {
            mobKills = 0;
            this.toolStats.logger.warn("{} does not have valid mob-kills set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER, (Object)(mobKills + add));
        String oldMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
        String newMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills + add);
        Component oldLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", oldMobKillsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", newMobKillsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateArmorDamage(ItemStack armorPiece, double damage, boolean bypass) {
        String newTokens;
        if (damage < 0.0 && !bypass) {
            return null;
        }
        ItemStack clone = armorPiece.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.armor-damage")) {
            if (container.has(this.toolStats.toolStatsKeys.getArmorDamage())) {
                String appliedTokens;
                Double armorDamage = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE);
                if (armorDamage == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getArmorDamage());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "damage-taken");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldDamageTakenFormatted = this.toolStats.numberFormat.formatDouble(armorDamage);
                    Component lineToRemove = this.toolStats.configTools.formatLore("damage-taken", "{damage}", oldDamageTakenFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "damage-taken");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getArmorDamage()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Double damageTaken = 0.0;
        if (container.has(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE)) {
            damageTaken = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE);
        }
        if (damageTaken == null) {
            damageTaken = 0.0;
            this.toolStats.logger.warn("{} does not have valid damage-taken set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE, (Object)(damageTaken + damage));
        String oldDamageFormatted = this.toolStats.numberFormat.formatDouble(damageTaken);
        String newDamageFormatted = this.toolStats.numberFormat.formatDouble(damageTaken + damage);
        Component oldLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", oldDamageFormatted);
        Component newLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", newDamageFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateWeaponDamage(ItemStack weapon, double damage, boolean bypass) {
        String newTokens;
        if (damage < 0.0 && !bypass) {
            return null;
        }
        ItemStack clone = weapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "damage-done")) {
            if (container.has(this.toolStats.toolStatsKeys.getDamageDone())) {
                String appliedTokens;
                Double damageDone = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE);
                if (damageDone == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getDamageDone());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "damage-done");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldDamageDoneFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
                    Component lineToRemove = this.toolStats.configTools.formatLore("damage-done", "{damage}", oldDamageDoneFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "damage-done");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getDamageDone()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Double damageDone = 0.0;
        if (container.has(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE)) {
            damageDone = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE);
        }
        if (damageDone == null) {
            damageDone = 0.0;
            this.toolStats.logger.warn("{} does not have valid damage-done set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE, (Object)(damageDone + damage));
        String oldDamageFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
        String newDamageFormatted = this.toolStats.numberFormat.formatDouble(damageDone + damage);
        Component oldLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", oldDamageFormatted);
        Component newLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", newDamageFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateFlightTime(ItemStack elytra, long duration) {
        String newTokens;
        ItemStack clone = elytra.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.flight-time")) {
            if (container.has(this.toolStats.toolStatsKeys.getFlightTime())) {
                String appliedTokens;
                Long flightTime = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG);
                if (flightTime == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getFlightTime());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "flight-time");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    List<Component> newLore;
                    if (this.toolStats.config.getString("messages.flight-time-old") != null) {
                        String oldFormatFormatted = this.toolStats.numberFormat.formatDouble((double)flightTime.longValue() / 1000.0);
                        Component oldFormat = this.toolStats.configTools.formatLore("flight-time-old", "{time}", oldFormatFormatted);
                        newLore = this.removeLore(meta.lore(), oldFormat);
                        meta.lore(newLore);
                    }
                    Map<String, String> oldFlightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
                    Component lineToRemove = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", oldFlightTimeFormatted);
                    newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "flight-time");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getFlightTime()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Long flightTime = 0L;
        if (container.has(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG)) {
            flightTime = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG);
        }
        if (flightTime == null) {
            flightTime = 0L;
            this.toolStats.logger.warn("{} does not have valid flight-time set! Resting to zero. This should NEVER happen.", (Object)flightTime);
        }
        container.set(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG, (Object)(flightTime + duration));
        Map<String, String> oldFlightFormatted = this.toolStats.numberFormat.formatTime(flightTime);
        Map<String, String> newFlightFormatted = this.toolStats.numberFormat.formatTime(flightTime + duration);
        if (this.toolStats.config.getString("messages.flight-time-old") != null && meta.hasLore()) {
            String oldFormatFormatted = this.toolStats.numberFormat.formatDouble((double)flightTime.longValue() / 1000.0);
            Component oldFormat = this.toolStats.configTools.formatLore("flight-time-old", "{time}", oldFormatFormatted);
            meta.lore(this.removeLore(meta.lore(), oldFormat));
        }
        Component oldLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", oldFlightFormatted);
        Component newLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", newFlightFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateSheepSheared(ItemStack shears, int add) {
        String newTokens;
        ItemStack clone = shears.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.sheep-sheared")) {
            if (container.has(this.toolStats.toolStatsKeys.getSheepSheared())) {
                String appliedTokens;
                Integer sheepSheared = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER);
                if (sheepSheared == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getSheepSheared());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "sheep-sheared");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldSheepShearedFormatted = this.toolStats.numberFormat.formatInt(sheepSheared);
                    Component lineToRemove = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", oldSheepShearedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "sheep-sheared");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getSheepSheared()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer sheepSheared = 0;
        if (container.has(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER)) {
            sheepSheared = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER);
        }
        if (sheepSheared == null) {
            sheepSheared = 0;
            this.toolStats.logger.warn("{} does not have valid sheared set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER, (Object)(sheepSheared + add));
        String oldSheepFormatted = this.toolStats.numberFormat.formatInt(sheepSheared);
        String newSheepFormatted = this.toolStats.numberFormat.formatInt(sheepSheared + add);
        Component oldLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", oldSheepFormatted);
        Component newLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", newSheepFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateArrowsShot(ItemStack bow, int add) {
        String newTokens;
        ItemStack clone = bow.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.arrows-shot")) {
            if (container.has(this.toolStats.toolStatsKeys.getArrowsShot())) {
                String appliedTokens;
                Integer arrowsShot = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER);
                if (arrowsShot == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getArrowsShot());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "arrows-shot");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldArrowsShotFormatted = this.toolStats.numberFormat.formatInt(arrowsShot);
                    Component lineToRemove = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", oldArrowsShotFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "arrows-shot");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getArrowsShot()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer arrowsShot = 0;
        if (container.has(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER)) {
            arrowsShot = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER);
        }
        if (arrowsShot == null) {
            arrowsShot = 0;
            this.toolStats.logger.warn("{} does not have valid arrows-shot set! Resting to zero. This should NEVER happen.", (Object)arrowsShot);
        }
        container.set(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER, (Object)(arrowsShot + add));
        String oldArrowsFormatted = this.toolStats.numberFormat.formatInt(arrowsShot);
        String newArrowsFormatted = this.toolStats.numberFormat.formatInt(arrowsShot + add);
        Component oldLine = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", oldArrowsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", newArrowsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateFishCaught(ItemStack fishingRod, int add) {
        String newTokens;
        ItemStack clone = fishingRod.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.fish-caught")) {
            if (container.has(this.toolStats.toolStatsKeys.getFishCaught())) {
                String appliedTokens;
                Integer fishCaught = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER);
                if (fishCaught == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getFishCaught());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "fish-caught");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldFishCaught = this.toolStats.numberFormat.formatInt(fishCaught);
                    Component lineToRemove = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", oldFishCaught);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "fish-caught");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getFishCaught()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer fishCaught = 0;
        if (container.has(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER)) {
            fishCaught = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER);
        }
        if (fishCaught == null) {
            fishCaught = 0;
            this.toolStats.logger.warn("{} does not have valid fish-caught set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER, (Object)(fishCaught + add));
        String oldFishFormatted = this.toolStats.numberFormat.formatInt(fishCaught);
        String newFishFormatted = this.toolStats.numberFormat.formatInt(fishCaught + add);
        Component oldLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", oldFishFormatted);
        Component newLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", newFishFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateBossesKilled(ItemStack weapon, int add, String boss) {
        String newTokens;
        ItemStack clone = weapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey bossesKey = null;
        if (boss.equalsIgnoreCase("wither")) {
            bossesKey = this.toolStats.toolStatsKeys.getWitherKills();
        }
        if (boss.equalsIgnoreCase("enderdragon")) {
            bossesKey = this.toolStats.toolStatsKeys.getEnderDragonKills();
        }
        if (bossesKey == null) {
            return null;
        }
        if (!this.toolStats.config.getBoolean("enabled.bosses-killed." + boss)) {
            if (container.has(bossesKey)) {
                String appliedTokens;
                Integer bossesKilled = (Integer)container.get(bossesKey, PersistentDataType.INTEGER);
                if (bossesKilled == null) {
                    return null;
                }
                container.remove(bossesKey);
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "wither-kills");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldBossesKilled = this.toolStats.numberFormat.formatInt(bossesKilled);
                    Component lineToRemove = this.toolStats.configTools.formatLore("bosses-killed." + boss, "{kills}", oldBossesKilled);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "wither-kills");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(bossesKey) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer bossesKilled = 0;
        if (container.has(bossesKey, PersistentDataType.INTEGER)) {
            bossesKilled = (Integer)container.get(bossesKey, PersistentDataType.INTEGER);
        }
        if (bossesKilled == null) {
            bossesKilled = 0;
            this.toolStats.logger.warn("{} does not have valid {} set! Resting to zero. This should NEVER happen.", (Object)clone, (Object)boss);
        }
        container.set(bossesKey, PersistentDataType.INTEGER, (Object)(bossesKilled + add));
        String oldBossesKilledFormatted = this.toolStats.numberFormat.formatInt(bossesKilled);
        String newBossesKilledFormatted = this.toolStats.numberFormat.formatInt(bossesKilled + add);
        Component oldLine = this.toolStats.configTools.formatLore("bosses-killed." + boss, "{kills}", oldBossesKilledFormatted);
        Component newLine = this.toolStats.configTools.formatLore("bosses-killed." + boss, "{kills}", newBossesKilledFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateCriticalStrikes(ItemStack weapon, int add) {
        String newTokens;
        ItemStack clone = weapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.critical-strikes")) {
            if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes())) {
                String appliedTokens;
                Integer criticalStrikes = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER);
                if (criticalStrikes == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getCriticalStrikes());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "critical-strikes");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldCriticalStrikes = this.toolStats.numberFormat.formatInt(criticalStrikes);
                    Component lineToRemove = this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", oldCriticalStrikes);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "critical-strikes");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer criticalStrikes = 0;
        if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER)) {
            criticalStrikes = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER);
        }
        if (criticalStrikes == null) {
            criticalStrikes = 0;
            this.toolStats.logger.warn("{} does not have valid fish-caught set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER, (Object)(criticalStrikes + add));
        String oldCriticalStrikesFormatted = this.toolStats.numberFormat.formatInt(criticalStrikes);
        String newCriticalStrikesFormatted = this.toolStats.numberFormat.formatInt(criticalStrikes + add);
        Component oldLine = this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", oldCriticalStrikesFormatted);
        Component newLine = this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", newCriticalStrikesFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateTridentThrows(ItemStack trident, int add) {
        String newTokens;
        ItemStack clone = trident.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.trident-throws")) {
            if (container.has(this.toolStats.toolStatsKeys.getTridentThrows())) {
                String appliedTokens;
                Integer tridentThrows = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER);
                if (tridentThrows == null) {
                    return null;
                }
                container.remove(this.toolStats.toolStatsKeys.getTridentThrows());
                if (container.has(this.toolStats.toolStatsKeys.getTokenApplied()) && (appliedTokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "trident-throws");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    }
                }
                if (meta.hasLore()) {
                    String oldTridentThrows = this.toolStats.numberFormat.formatInt(tridentThrows);
                    Component lineToRemove = this.toolStats.configTools.formatLore("trident-throws", "{times}", oldTridentThrows);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "trident-throws");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.toolStatsKeys.getTridentThrows()) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
        }
        Integer tridentThrows = 0;
        if (container.has(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER)) {
            tridentThrows = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER);
        }
        if (tridentThrows == null) {
            tridentThrows = 0;
            this.toolStats.logger.warn("{} does not have valid fish-caught set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER, (Object)(tridentThrows + add));
        String oldTridentThrowsFormatted = this.toolStats.numberFormat.formatInt(tridentThrows);
        String newTridentThrowsFormatted = this.toolStats.numberFormat.formatInt(tridentThrows + add);
        Component oldLine = this.toolStats.configTools.formatLore("trident-throws", "{times}", oldTridentThrowsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("trident-throws", "{times}", newTridentThrowsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        this.toolStats.logger.info(meta.toString());
        return meta;
    }

    public Component formatOwner(String playerName, int origin, ItemStack item) {
        switch (origin) {
            case 0: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "crafted-by")) break;
                return this.toolStats.configTools.formatLore("crafted.crafted-by", "{player}", playerName);
            }
            case 2: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "looted-by")) break;
                return this.toolStats.configTools.formatLore("looted.looted-by", "{player}", playerName);
            }
            case 3: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "traded-by")) break;
                return this.toolStats.configTools.formatLore("traded.traded-by", "{player}", playerName);
            }
            case 4: {
                if (!this.toolStats.config.getBoolean("enabled.elytra-tag")) break;
                return this.toolStats.configTools.formatLore("looted.found-by", "{player}", playerName);
            }
            case 5: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "fished-by")) break;
                return this.toolStats.configTools.formatLore("fished.caught-by", "{player}", playerName);
            }
            case 6: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "spawned-in-by")) break;
                return this.toolStats.configTools.formatLore("spawned-in.spawned-by", "{player}", playerName);
            }
        }
        return null;
    }

    public Component formatCreationTime(long creationDate, int origin, ItemStack item) {
        String date = this.toolStats.numberFormat.formatDate(new Date(creationDate));
        switch (origin) {
            case 0: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "crafted-on")) break;
                return this.toolStats.configTools.formatLore("crafted.crafted-on", "{date}", date);
            }
            case 1: {
                if (!this.toolStats.config.getBoolean("enabled.dropped-on")) break;
                return this.toolStats.configTools.formatLore("dropped-on", "{date}", date);
            }
            case 2: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "looted-on")) break;
                return this.toolStats.configTools.formatLore("looted.looted-on", "{date}", date);
            }
            case 3: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "traded-on")) break;
                return this.toolStats.configTools.formatLore("traded.traded-on", "{date}", date);
            }
            case 4: {
                if (!this.toolStats.config.getBoolean("enabled.elytra-tag")) break;
                return this.toolStats.configTools.formatLore("looted.found-on", "{date}", date);
            }
            case 5: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "fished-on")) break;
                return this.toolStats.configTools.formatLore("fished.caught-on", "{date}", date);
            }
            case 6: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "spawned-in-on")) break;
                return this.toolStats.configTools.formatLore("spawned-in.spawned-on", "{date}", date);
            }
        }
        return null;
    }

    public ItemStack removeAll(ItemStack inputItem, boolean removeMeta) {
        Integer criticalStrikes;
        Integer enderDragonKills;
        Integer witherKills;
        Long flightTime;
        Integer arrowsShot;
        Double damageDone;
        Double armorDamage;
        Integer sheepSheared;
        Integer fishCaught;
        Integer cropsHarvested;
        Integer blocksMined;
        Integer mobKills;
        Component lineToRemove;
        Integer playerKills;
        ItemStack finalItem = inputItem.clone();
        ItemMeta meta = finalItem.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.toolStats.toolStatsKeys.getTokenApplied())) {
            container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
        }
        if (container.has(this.toolStats.toolStatsKeys.getPlayerKills()) && (playerKills = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getPlayerKills());
            String playerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
            lineToRemove = this.toolStats.configTools.formatLore("kills.player", "{kills}", playerKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getMobKills()) && (mobKills = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getMobKills());
            String mobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
            lineToRemove = this.toolStats.configTools.formatLore("kills.mob", "{kills}", mobKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getBlocksMined()) && (blocksMined = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getBlocksMined());
            String blocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
            lineToRemove = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", blocksMinedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested()) && (cropsHarvested = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getCropsHarvested());
            String cropsHarvestedFormatted = this.toolStats.numberFormat.formatInt(cropsHarvested);
            lineToRemove = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", cropsHarvestedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getFishCaught()) && (fishCaught = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getFishCaught());
            String fishCaughtFormatted = this.toolStats.numberFormat.formatInt(fishCaught);
            lineToRemove = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", fishCaughtFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getSheepSheared()) && (sheepSheared = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getSheepSheared());
            String sheepShearedFormatted = this.toolStats.numberFormat.formatInt(sheepSheared);
            lineToRemove = this.toolStats.configTools.formatLore("sheep.sheared", "{sheep}", sheepShearedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getArmorDamage()) && (armorDamage = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getArmorDamage());
            String armorDamageFormatted = this.toolStats.numberFormat.formatDouble(armorDamage);
            lineToRemove = this.toolStats.configTools.formatLore("damage-taken", "{damage}", armorDamageFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getDamageDone()) && (damageDone = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getDamageDone());
            String damageDoneFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
            lineToRemove = this.toolStats.configTools.formatLore("damage-done", "{damage}", damageDoneFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getArrowsShot()) && (arrowsShot = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getArrowsShot());
            String arrowsShotFormatted = this.toolStats.numberFormat.formatInt(arrowsShot);
            lineToRemove = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", arrowsShotFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getFlightTime()) && (flightTime = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getFlightTime());
            Map<String, String> flightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
            lineToRemove = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", flightTimeFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getWitherKills()) && (witherKills = (Integer)container.get(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getWitherKills());
            String witherKillsFormatted = this.toolStats.numberFormat.formatInt(witherKills);
            lineToRemove = this.toolStats.configTools.formatLore("bosses-killed.wither", "{kills}", witherKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getEnderDragonKills()) && (enderDragonKills = (Integer)container.get(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getEnderDragonKills());
            String enderDragonKillsFormatted = this.toolStats.numberFormat.formatInt(enderDragonKills);
            lineToRemove = this.toolStats.configTools.formatLore("bosses-killed.enderdragon", "{kills}", enderDragonKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes()) && (criticalStrikes = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.toolStatsKeys.getCriticalStrikes());
            String criticalStrikesFormatted = this.toolStats.numberFormat.formatInt(criticalStrikes);
            lineToRemove = this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", criticalStrikesFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (removeMeta) {
            UUID owner;
            Long timeCreated;
            Integer origin = null;
            if (container.has(this.toolStats.toolStatsKeys.getOriginType())) {
                origin = (Integer)container.get(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER);
            }
            if (container.has(this.toolStats.toolStatsKeys.getTimeCreated()) && (timeCreated = (Long)container.get(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG)) != null && origin != null) {
                container.remove(this.toolStats.toolStatsKeys.getTimeCreated());
                Component timeCreatedLore = this.formatCreationTime(timeCreated, origin, finalItem);
                meta.lore(this.removeLore(meta.lore(), timeCreatedLore));
            }
            if (container.has(this.toolStats.toolStatsKeys.getItemOwner()) && (owner = (UUID)container.get(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) != null && origin != null) {
                container.remove(this.toolStats.toolStatsKeys.getItemOwner());
                String ownerName = Bukkit.getOfflinePlayer((UUID)owner).getName();
                if (ownerName != null) {
                    Component ownerLore = this.formatOwner(ownerName, origin, finalItem);
                    meta.lore(this.removeLore(meta.lore(), ownerLore));
                }
            }
            if (origin != null) {
                container.remove(this.toolStats.toolStatsKeys.getOriginType());
            }
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }
}

