/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class ItemChecker {
    private final List<Material> validItems = new ArrayList<Material>();
    private final List<Material> armorItems = new ArrayList<Material>();
    private final List<Material> meleeItems = new ArrayList<Material>();
    private final List<Material> mineItems = new ArrayList<Material>();
    private final ToolStats toolStats;

    public ItemChecker(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void setup() {
        for (Material material : Material.values()) {
            String lowerCase = material.toString().toLowerCase(Locale.ROOT);
            if (lowerCase.contains("_pickaxe") || lowerCase.contains("_axe") || lowerCase.contains("_hoe") || lowerCase.contains("_shovel")) {
                this.mineItems.add(material);
            }
            if (lowerCase.contains("_sword") || lowerCase.contains("_axe") || lowerCase.contains("_spear")) {
                this.meleeItems.add(material);
            }
            if (!lowerCase.contains("_helmet") && !lowerCase.contains("_chestplate") && !lowerCase.contains("_leggings") && !lowerCase.contains("_boots")) continue;
            this.armorItems.add(material);
        }
        this.mineItems.add(Material.SHEARS);
        this.meleeItems.add(Material.TRIDENT);
        this.meleeItems.add(Material.MACE);
        this.validItems.add(Material.BOW);
        this.validItems.add(Material.CROSSBOW);
        this.validItems.add(Material.FISHING_ROD);
        this.validItems.add(Material.ELYTRA);
        this.validItems.add(Material.SHIELD);
        this.validItems.addAll(this.armorItems);
        this.validItems.addAll(this.meleeItems);
        this.validItems.addAll(this.mineItems);
    }

    public boolean isArmor(Material itemType) {
        return this.armorItems.contains(itemType);
    }

    public boolean isValidItem(Material itemType) {
        return this.validItems.contains(itemType);
    }

    public boolean isMeleeWeapon(Material itemType) {
        return this.meleeItems.contains(itemType);
    }

    public boolean isMineTool(Material itemType) {
        return this.mineItems.contains(itemType);
    }

    public boolean canGlide(ItemStack itemStack) {
        if (itemStack.getType() == Material.ELYTRA) {
            return true;
        }
        return itemStack.hasData((DataComponentType)DataComponentTypes.GLIDER);
    }

    public boolean checkTokens(PersistentDataContainer container, String targetToken) {
        if (!container.has(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) {
            return false;
        }
        String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
        if (tokens == null) {
            return false;
        }
        return tokens.contains(targetToken);
    }

    private String[] getTokens(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return new String[0];
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING)) {
            return new String[0];
        }
        String tokensRaw = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
        if (tokensRaw == null) {
            return new String[0];
        }
        return tokensRaw.split(",");
    }

    public ItemStack addToken(ItemStack item, String token) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String[] tokens = this.getTokens(item);
        if (tokens.length == 0) {
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)token);
        } else {
            CharSequence[] newTokens = Arrays.copyOf(tokens, tokens.length + 1);
            newTokens[tokens.length] = token;
            container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
        }
        item.setItemMeta(meta);
        return item;
    }

    public int getCost(String tokenType) {
        return this.toolStats.config.getInt("tokens.data." + tokenType + ".levels");
    }

    @Nullable
    public ItemStack getBow(PlayerInventory inventory) {
        boolean isOffHand;
        ItemStack main = inventory.getItemInMainHand();
        ItemStack offHand = inventory.getItemInOffHand();
        boolean isMain = main.getType() == Material.BOW || main.getType() == Material.CROSSBOW;
        boolean bl = isOffHand = offHand.getType() == Material.BOW || offHand.getType() == Material.CROSSBOW;
        if (isMain && isOffHand) {
            return main;
        }
        if (isMain) {
            return main;
        }
        if (isOffHand) {
            return offHand;
        }
        return null;
    }

    @Nullable
    public ItemStack getShears(PlayerInventory inventory) {
        boolean isOffHand;
        ItemStack main = inventory.getItemInMainHand();
        ItemStack offHand = inventory.getItemInOffHand();
        boolean isMain = main.getType() == Material.SHEARS;
        boolean bl = isOffHand = offHand.getType() == Material.SHEARS;
        if (isMain && isOffHand) {
            return main;
        }
        if (isMain) {
            return main;
        }
        if (isOffHand) {
            return offHand;
        }
        return null;
    }

    @Nullable
    public ItemStack getFishingRod(PlayerInventory inventory) {
        boolean isOffHand;
        ItemStack main = inventory.getItemInMainHand();
        ItemStack offHand = inventory.getItemInOffHand();
        boolean isMain = main.getType() == Material.FISHING_ROD;
        boolean bl = isOffHand = offHand.getType() == Material.FISHING_ROD;
        if (isMain && isOffHand) {
            return main;
        }
        if (isMain) {
            return main;
        }
        if (isOffHand) {
            return offHand;
        }
        return null;
    }

    public String addTokensToExisting(ItemStack item) {
        ItemStack clone = item.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        ArrayList<String> tokens = new ArrayList<String>();
        if (container.has(this.toolStats.toolStatsKeys.getPlayerKills())) {
            tokens.add("player-kills");
        }
        if (container.has(this.toolStats.toolStatsKeys.getMobKills())) {
            tokens.add("mob-kills");
        }
        if (container.has(this.toolStats.toolStatsKeys.getBlocksMined())) {
            tokens.add("blocks-mined");
        }
        if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested())) {
            tokens.add("crops-mined");
        }
        if (container.has(this.toolStats.toolStatsKeys.getFishCaught())) {
            tokens.add("fish-caught");
        }
        if (container.has(this.toolStats.toolStatsKeys.getSheepSheared())) {
            tokens.add("sheep-sheared");
        }
        if (container.has(this.toolStats.toolStatsKeys.getArmorDamage())) {
            tokens.add("damage-taken");
        }
        if (container.has(this.toolStats.toolStatsKeys.getArrowsShot())) {
            tokens.add("arrows-shot");
        }
        if (container.has(this.toolStats.toolStatsKeys.getFlightTime())) {
            tokens.add("flight-time");
        }
        if (container.has(this.toolStats.toolStatsKeys.getDamageDone())) {
            tokens.add("damage-done");
        }
        if (container.has(this.toolStats.toolStatsKeys.getWitherKills())) {
            tokens.add("wither-kills");
        }
        if (container.has(this.toolStats.toolStatsKeys.getEnderDragonKills())) {
            tokens.add("enderdragon-kills");
        }
        if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes())) {
            tokens.add("critical-strikes");
        }
        if (container.has(this.toolStats.toolStatsKeys.getTridentThrows())) {
            tokens.add("trident-throws");
        }
        if (tokens.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", tokens);
    }

    public List<String> removeToken(String appliedTokens, String toRemove) {
        ArrayList<String> tokenList = new ArrayList<String>(Arrays.asList(appliedTokens.split(",")));
        tokenList.remove(toRemove);
        if (tokenList.isEmpty()) {
            return Collections.emptyList();
        }
        return tokenList;
    }

    public boolean keyCheck(PersistentDataContainer container) {
        return container.getKeys().stream().map(NamespacedKey::getKey).anyMatch(key -> this.toolStats.toolStatsKeys.getTokenKeys().stream().anyMatch(tokenKey -> tokenKey.getKey().equalsIgnoreCase((String)key)));
    }
}

