/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.hyperlib.releases.github;

import java.util.ArrayList;
import java.util.List;
import lol.hyper.toolstats.hyperlib.HyperLib;
import lol.hyper.toolstats.hyperlib.releases.github.GitHubDownload;
import lol.hyper.toolstats.hyperlib.releases.github.GitHubRelease;
import lol.hyper.toolstats.hyperlib.utils.JSONUtils;
import lol.hyper.toolstats.shaded.json.JSONArray;
import lol.hyper.toolstats.shaded.json.JSONObject;
import org.jetbrains.annotations.Nullable;

public class GitHubPlugin {
    private final String organization;
    private final String repository;
    private final List<GitHubRelease> releases = new ArrayList<GitHubRelease>();
    private String latest;
    private String gitHubUrl;

    public GitHubPlugin(String organization, String repository) {
        this.organization = organization;
        this.repository = repository;
    }

    public void get() {
        this.gitHubUrl = "https://github.com/" + this.organization + "/" + this.repository;
        String apiUrl = "https://api.github.com/repos/" + this.organization + "/" + this.repository;
        JSONArray releasesFetch = JSONUtils.requestJSONArray(apiUrl + "/releases");
        if (releasesFetch == null) {
            HyperLib.getPluginLogger().error("Unable to fetch plugin information from {}", (Object)(apiUrl + "/releases"));
            return;
        }
        for (int i = 0; i < releasesFetch.length(); ++i) {
            JSONObject releaseData = releasesFetch.getJSONObject(i);
            String version = releaseData.getString("tag_name");
            GitHubRelease gitHubRelease = new GitHubRelease(version);
            JSONObject author = releaseData.getJSONObject("author");
            gitHubRelease.setAuthor(author.getString("login"));
            gitHubRelease.setVersionPage(this.gitHubUrl + "/releases/tag/" + version);
            gitHubRelease.setReleaseDate(releaseData.getString("published_at"));
            JSONArray assets = releaseData.getJSONArray("assets");
            for (int j = 0; j < assets.length(); ++j) {
                JSONObject assetData = assets.getJSONObject(j);
                if (!assetData.getString("content_type").equalsIgnoreCase("application/java-archive")) continue;
                GitHubDownload gitHubDownload = new GitHubDownload(version);
                gitHubDownload.setDownloadUrl(assetData.getString("browser_download_url"));
                gitHubDownload.setFileName(assetData.getString("name"));
                String digest = assetData.optString("digest", null);
                digest = digest != null ? digest.replace("sha256:", "") : "UNKNOWN";
                gitHubDownload.setSha256Hash(digest);
                gitHubRelease.addDownload(gitHubDownload);
            }
            this.releases.add(gitHubRelease);
            if (i != 0) continue;
            this.latest = version;
        }
    }

    public List<GitHubRelease> getReleases() {
        return this.releases;
    }

    @Nullable
    public GitHubRelease getReleaseByVersion(String version) {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(version)).findFirst().orElse(null);
    }

    @Nullable
    public GitHubRelease getLatestRelease() {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(this.latest)).findFirst().get();
    }

    public int buildsVersionsBehind(GitHubRelease release) {
        return this.releases.indexOf(release);
    }

    public String getProjectPage() {
        return this.gitHubUrl;
    }
}

