/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import lol.hyper.toolstats.ToolStats;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class SheepShear
implements Listener {
    private final ToolStats toolStats;

    public SheepShear(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onShear(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        ItemStack heldShears = this.toolStats.itemChecker.getShears(player.getInventory());
        if (heldShears == null) {
            return;
        }
        if (sheep.isSheared()) {
            return;
        }
        ItemMeta newShears = this.toolStats.itemLore.updateSheepSheared(heldShears, 1);
        if (newShears != null) {
            boolean isOffHand;
            PlayerInventory inventory = player.getInventory();
            boolean isMain = inventory.getItemInMainHand().getType() == Material.SHEARS;
            boolean bl = isOffHand = inventory.getItemInOffHand().getType() == Material.SHEARS;
            if (isMain && isOffHand) {
                inventory.getItemInMainHand().setItemMeta(newShears);
            } else if (isMain) {
                inventory.getItemInMainHand().setItemMeta(newShears);
            } else if (isOffHand) {
                inventory.getItemInOffHand().setItemMeta(newShears);
            }
        }
    }
}

