/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.HashMap;
import java.util.Map;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerMove
implements Listener {
    private final ToolStats toolStats;
    private final Map<Player, Long> playerStartFlight = new HashMap<Player, Long>();

    public PlayerMove(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.isGliding()) {
            if (!this.playerStartFlight.containsKey(player)) {
                this.playerStartFlight.put(player, System.currentTimeMillis());
            }
        } else if (this.playerStartFlight.containsKey(player)) {
            ItemStack[] armor;
            PlayerInventory inventory = player.getInventory();
            for (ItemStack armorPiece : armor = (ItemStack[])inventory.getArmorContents().clone()) {
                long duration;
                ItemMeta newMeta;
                if (armorPiece == null || !this.toolStats.itemChecker.canGlide(armorPiece) || (newMeta = this.toolStats.itemLore.updateFlightTime(armorPiece, duration = System.currentTimeMillis() - this.playerStartFlight.get(player))) == null) continue;
                armorPiece.setItemMeta(newMeta);
            }
            inventory.setArmorContents(armor);
            this.playerStartFlight.remove(player);
        }
    }
}

