/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PlayerFish
implements Listener {
    private final ToolStats toolStats;

    public PlayerFish(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFish(PlayerFishEvent event) {
        ItemStack newItem;
        if (event.isCancelled()) {
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        ItemStack fishingRod = this.toolStats.itemChecker.getFishingRod(player.getInventory());
        if (fishingRod == null) {
            return;
        }
        ItemMeta newFishingRod = this.toolStats.itemLore.updateFishCaught(fishingRod, 1);
        if (newFishingRod != null) {
            boolean isOffHand;
            PlayerInventory inventory = player.getInventory();
            boolean isMain = inventory.getItemInMainHand().getType() == Material.FISHING_ROD;
            boolean bl = isOffHand = inventory.getItemInOffHand().getType() == Material.FISHING_ROD;
            if (isMain && isOffHand) {
                inventory.getItemInMainHand().setItemMeta(newFishingRod);
            } else if (isMain) {
                inventory.getItemInMainHand().setItemMeta(newFishingRod);
            } else if (isOffHand) {
                inventory.getItemInOffHand().setItemMeta(newFishingRod);
            }
        }
        if (event.getCaught() == null) {
            return;
        }
        ItemStack caughtItem = ((Item)event.getCaught()).getItemStack();
        Item caughtItemEntity = (Item)event.getCaught();
        if (this.toolStats.itemChecker.isValidItem(caughtItem.getType()) && (newItem = this.addFishedOrigin(caughtItem, player)) != null) {
            caughtItemEntity.setItemStack(newItem);
        }
    }

    private ItemStack addFishedOrigin(ItemStack originalItem, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = originalItem.clone();
        ItemMeta meta = originalItem.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG) || container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 5, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)5);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 5, newItem)) != null) {
            container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)5);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }
}

