/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import lol.hyper.toolstats.ToolStats;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerDrop
implements Listener {
    private final ToolStats toolStats;

    public PlayerDrop(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (this.toolStats.generateLoot.generatedInventory.isEmpty()) {
            return;
        }
        player.getScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> {
            Inventory opened = player.getOpenInventory().getTopInventory();
            if (this.toolStats.generateLoot.generatedInventory.containsKey(opened)) {
                Item droppedItemEntity = event.getItemDrop();
                ItemStack droppedItem = droppedItemEntity.getItemStack();
                if (!this.toolStats.itemChecker.isValidItem(droppedItem.getType())) {
                    return;
                }
                ItemStack newItem = this.toolStats.inventoryClose.addLootedOrigin(droppedItem, player);
                if (newItem != null) {
                    droppedItemEntity.setItemStack(newItem);
                }
            }
        }, null, 1L);
    }
}

