/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PickupItem
implements Listener {
    private final ToolStats toolStats;

    public PickupItem(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPickup(EntityPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
                return;
            }
            Item item = event.getItem();
            if (item.getType() == EntityType.ITEM) {
                ItemStack newElytra;
                ItemStack itemStack = event.getItem().getItemStack();
                ItemMeta meta = itemStack.getItemMeta();
                if (meta == null) {
                    return;
                }
                PersistentDataContainer container = meta.getPersistentDataContainer();
                if (itemStack.getType() == Material.ELYTRA && container.has(this.toolStats.toolStatsKeys.getElytraKey(), PersistentDataType.INTEGER) && (newElytra = this.addElytraOrigin(itemStack, (Player)event.getEntity())) != null) {
                    item.setItemStack(newElytra);
                }
            }
        }
    }

    private ItemStack addElytraOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        ItemStack finalItem = itemStack.clone();
        ItemMeta meta = finalItem.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.elytra-tag")) {
            return null;
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(finalItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
        container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
        container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)4);
        container.remove(this.toolStats.toolStatsKeys.getElytraKey());
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 4, finalItem);
        if (creationDate != null) {
            container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)4);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 4, finalItem)) != null) {
            container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)4);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        finalItem.setItemMeta(meta);
        return finalItem;
    }
}

